/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.common;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.ForbiddenException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.UnauthorizedException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import eu.dnetlib.uoamonitorservice.common.Common;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.primitives.Visibility;

public abstract class BaseService {
    AuthorizationService authorizationService;

    protected BaseService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    protected boolean hasAccessAuthority(Stakeholder stakeholder) {
        if (this.authorizationService.isPortalAdmin() || this.authorizationService.isCurator(stakeholder.getType())) {
            return true;
        }
        if (!stakeholder.isDefault()) {
            return this.authorizationService.isManager(stakeholder.getType(), stakeholder.getAlias());
        }
        return false;
    }

    protected boolean hasDeleteAuthority(Stakeholder stakeholder) {
        return this.authorizationService.isPortalAdmin() || this.authorizationService.isCurator(stakeholder.getType());
    }

    protected boolean hasCreateAuthority(Stakeholder stakeholder) {
        return this.authorizationService.isPortalAdmin() || this.authorizationService.isCurator(stakeholder.getType());
    }

    protected boolean hasEditAuthority(Stakeholder stakeholder) {
        return this.authorizationService.isPortalAdmin() || this.authorizationService.isCurator(stakeholder.getType()) || this.authorizationService.isManager(stakeholder.getType(), stakeholder.getAlias());
    }

    protected boolean hasVisibilityAuthority(Stakeholder stakeholder, Common common) {
        if (common.getVisibility() == null) {
            return true;
        }
        if (this.authorizationService.isPortalAdmin() || this.authorizationService.isCurator(stakeholder.getType()) || this.authorizationService.isManager(stakeholder.getType(), stakeholder.getAlias())) {
            return true;
        }
        if (this.authorizationService.isMember(stakeholder.getType(), stakeholder.getAlias()) && !common.getVisibility().equals(Visibility.PRIVATE.getLabel())) {
            return true;
        }
        return common.getVisibility().equals(Visibility.PUBLIC.getLabel());
    }

    public void unauthorized(String message) {
        if (this.authorizationService.getAaiId() != null) {
            throw new ForbiddenException(message);
        }
        throw new UnauthorizedException(message);
    }
}

