/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.generics;

import eu.dnetlib.uoamonitorservice.annotations.Children;
import eu.dnetlib.uoamonitorservice.annotations.Overridable;
import eu.dnetlib.uoamonitorservice.annotations.Unmodifiable;
import eu.dnetlib.uoamonitorservice.common.Common;
import eu.dnetlib.uoamonitorservice.primitives.IndicatorSize;
import eu.dnetlib.uoamonitorservice.primitives.IndicatorType;
import eu.dnetlib.uoamonitorservice.utils.EnumUtils;
import java.util.ArrayList;
import java.util.List;

public class IndicatorGeneric<T>
extends Common {
    protected String additionalDescription;
    @Unmodifiable
    protected IndicatorType type;
    protected IndicatorSize width;
    protected IndicatorSize height = IndicatorSize.MEDIUM;
    @Children
    @Overridable
    protected List<T> indicatorPaths;

    public IndicatorGeneric() {
    }

    public IndicatorGeneric(IndicatorGeneric<?> indicator) {
        super(indicator);
        this.additionalDescription = indicator.getAdditionalDescription();
        this.setType(indicator.getType());
        this.setWidth(indicator.getWidth());
        this.setHeight(indicator.getHeight());
        this.indicatorPaths = new ArrayList<T>();
    }

    public String getAdditionalDescription() {
        return this.additionalDescription;
    }

    public void setAdditionalDescription(String description) {
        this.additionalDescription = description;
    }

    public String getType() {
        return EnumUtils.toLabel(this.type);
    }

    public void setType(String type) {
        this.type = IndicatorType.fromLabel(type);
    }

    public String getWidth() {
        return EnumUtils.toLabel(this.width);
    }

    public void setWidth(String width) {
        this.width = IndicatorSize.fromLabel(width);
    }

    public String getHeight() {
        return EnumUtils.toLabel(this.height);
    }

    public void setHeight(String height) {
        this.height = IndicatorSize.fromLabel(height);
    }

    public List<T> getIndicatorPaths() {
        return this.indicatorPaths;
    }

    public void setIndicatorPaths(List<T> indicatorPaths) {
        this.indicatorPaths = indicatorPaths;
    }
}

