/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.uoamonitorservice.annotations.Overridable;
import eu.dnetlib.uoamonitorservice.annotations.Unmodifiable;
import eu.dnetlib.uoamonitorservice.common.Void;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.handlers.BadRequestException;
import eu.dnetlib.uoamonitorservice.primitives.Visibility;
import eu.dnetlib.uoamonitorservice.utils.EnumUtils;
import eu.dnetlib.uoamonitorservice.utils.GenericAccessor;
import eu.dnetlib.uoamonitorservice.utils.ReflectionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.annotation.Transient;

public class Common
extends Void {
    @Id
    @JsonProperty(value="_id")
    protected String id;
    @CreatedDate
    protected Date creationDate;
    @LastModifiedDate
    protected Date updateDate;
    @Unmodifiable
    protected String parentId;
    @Overridable
    protected String name;
    @Overridable
    protected String description;
    @Overridable
    protected String alias;
    @Overridable
    protected String icon;
    @Overridable
    protected Visibility visibility;
    @Transient
    protected Map<String, Object> override;

    protected Common() {
    }

    protected Common(Common common) {
        this.id = common.getId();
        this.creationDate = common.getCreationDate();
        this.updateDate = common.getUpdateDate();
        this.parentId = common.parentId;
        this.name = common.getName();
        this.description = common.getDescription();
        this.alias = common.getAlias();
        this.icon = common.getIcon();
        this.setVisibility(common.getVisibility());
        this.override = common.getOverride();
    }

    public void update(Common common) {
        this.id = common.getId();
        this.creationDate = common.getCreationDate();
        this.updateDate = common.getUpdateDate();
    }

    public Map<String, Object> override(Common base, Set<String> fields) {
        return ReflectionUtils.getOverrides(base, this, fields);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getVisibility() {
        return EnumUtils.toLabel(this.visibility);
    }

    public void setVisibility(String visibility) {
        this.visibility = Visibility.fromLabel(visibility);
    }

    public void override(Stakeholder stakeholder) {
        if (stakeholder != null && stakeholder.isReference()) {
            Map<String, Object> override = stakeholder.getOverride(this.id);
            override.forEach((field, value) -> ReflectionUtils.setField(this, field, value));
            this.setOverride(override);
        }
    }

    @JsonIgnore
    public Map<String, Object> getOverride() {
        return this.override;
    }

    public void setOverride(Map<String, Object> override) {
        this.override = override;
    }

    public boolean isRestorable() {
        if (this.getOverride() != null && !this.getOverride().isEmpty()) {
            return this.override.keySet().stream().anyMatch(key -> GenericAccessor.getRestorableFields(this.getClass()).stream().anyMatch(key::startsWith));
        }
        return false;
    }

    public boolean isOwnedBy(Stakeholder stakeholder) {
        return this.parentId != null && stakeholder != null && this.parentId.equals(stakeholder.getId());
    }

    @JsonIgnore
    public List<String> getChildrenFields() {
        return GenericAccessor.getChildrenFields(this.getClass());
    }

    public boolean isChildrenField(String field) {
        return this.getChildrenFields().contains(field);
    }

    @JsonIgnore
    public List<?> getChildren(String field) {
        if (this.isChildrenField(field)) {
            return (List)ReflectionUtils.getField(this, field);
        }
        return new ArrayList();
    }

    public void addChild(String field, String child) {
        try {
            List<String> children = this.getChildren(field);
            children.add(child);
            this.setChildren(field, children);
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Use addChild only in object with String children. Not in Full Object");
        }
    }

    public void removeChild(String field, String child) {
        try {
            List<String> children = this.getChildren(field);
            children.remove(child);
            this.setChildren(field, children);
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Use removeChild only in object with String children. Not in Full Object");
        }
    }

    public void setChildren(String field, List<String> ids) {
        if (this.isChildrenField(field)) {
            ReflectionUtils.setField(this, field, ids);
        }
    }

    public boolean canModifyChildren() {
        return true;
    }
}

