/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.utils;

import java.lang.reflect.Field;

/*
 * Exception performing whole class analysis ignored.
 */
public class GenericAccessor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> void setField(Object obj, String fieldName, T value) {
        try {
            Field field = GenericAccessor.findField(obj.getClass(), (String)fieldName);
            field.setAccessible(true);
            if (field.getType().isEnum()) {
                if (value instanceof String) {
                    String stringValue = (String)value;
                    Enum enumValue = GenericAccessor.getEnumValue(field.getType(), (String)stringValue);
                    field.set(obj, enumValue);
                    return;
                } else {
                    if (!field.getType().isAssignableFrom(value.getClass())) throw new IllegalArgumentException("Incompatible types: cannot assign " + value.getClass().getName() + " to " + field.getType().getName());
                    field.set(obj, value);
                }
                return;
            } else {
                field.set(obj, value);
            }
            return;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            System.err.println("Error setting field: " + e.getMessage());
        }
    }

    public static Object getField(Object obj, String fieldName) {
        try {
            Field field = GenericAccessor.findField(obj.getClass(), (String)fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            System.err.println("Error getting field: " + e.getMessage());
            return null;
        }
    }

    private static Field findField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException("Field '" + fieldName + "' not found in class hierarchy of " + clazz.getName());
    }

    private static <E extends Enum<E>> E getEnumValue(Class<?> enumClass, String value) {
        return (E)Enum.valueOf(enumClass, value);
    }
}

