/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.service;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoamonitorservice.dao.StakeholderDAO;
import eu.dnetlib.uoamonitorservice.dao.TopicDAO;
import eu.dnetlib.uoamonitorservice.dto.TopicFull;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.generics.Common;
import eu.dnetlib.uoamonitorservice.generics.TopicGeneric;
import eu.dnetlib.uoamonitorservice.handlers.PathNotValidException;
import eu.dnetlib.uoamonitorservice.primitives.Visibility;
import eu.dnetlib.uoamonitorservice.service.CategoryService;
import eu.dnetlib.uoamonitorservice.service.CommonService;
import eu.dnetlib.uoamonitorservice.service.StakeholderService;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TopicService {
    private final StakeholderDAO stakeholderDAO;
    private final TopicDAO dao;
    private final CategoryService categoryService;
    private final CommonService commonService;

    @Autowired
    public TopicService(StakeholderDAO stakeholderDAO, TopicDAO dao, CategoryService categoryService, CommonService commonService) {
        this.stakeholderDAO = stakeholderDAO;
        this.dao = dao;
        this.categoryService = categoryService;
        this.commonService = commonService;
    }

    public Topic find(String id) {
        return (Topic)this.dao.findById((Object)id).orElseThrow(() -> new NotFoundException("Topic with id: " + id + " not found"));
    }

    public Topic findByPath(StakeholderService service, String stakeholderId, String topicId) {
        Stakeholder stakeholder = service.findByPath(stakeholderId);
        if (stakeholder.isReference()) {
            stakeholder = service.findByPath(stakeholder.getDefaultId());
        }
        return this.findByPath(stakeholder, topicId);
    }

    public Topic findByPath(Stakeholder stakeholder, String topicId) {
        if (!stakeholder.getTopics().contains(topicId)) {
            throw new PathNotValidException("Topic with id: " + topicId + " not found in Stakeholder: " + stakeholder.getId());
        }
        return (Topic)this.dao.findById((Object)topicId).orElseThrow(() -> new NotFoundException("Topic with id: " + topicId + " not found"));
    }

    public TopicFull getFullTopic(Stakeholder stakeholder, Topic topic) {
        topic.override(stakeholder);
        if (this.commonService.hasVisibilityAuthority(stakeholder.getType(), stakeholder.getAlias(), (Common)topic)) {
            return new TopicFull((TopicGeneric)topic, topic.getCategories().stream().map(categoryId -> this.categoryService.getFullCategory(stakeholder, categoryId)).collect(Collectors.toList()));
        }
        return null;
    }

    public TopicFull getFullTopic(Stakeholder stakeholder, String id) {
        Topic topic = this.find(id);
        return this.getFullTopic(stakeholder, topic);
    }

    public String build(String id) {
        Topic topic = this.find(id);
        Topic copy = topic.copy();
        copy.setCategories(topic.getCategories().stream().map(arg_0 -> ((CategoryService)this.categoryService).build(arg_0)).collect(Collectors.toList()));
        return this.save(copy).getId();
    }

    public String copy(String id) {
        Topic topic = this.find(id);
        Topic copy = new Topic(topic);
        copy.setId(null);
        copy.setCategories(topic.getCategories().stream().map(arg_0 -> ((CategoryService)this.categoryService).copy(arg_0)).collect(Collectors.toList()));
        return this.save(copy).getId();
    }

    public Topic save(Topic topic) {
        if (topic.getId() != null) {
            topic.setCategories(this.find(topic.getId()).getCategories());
        }
        topic.getCategories().forEach(arg_0 -> ((CategoryService)this.categoryService).find(arg_0));
        return (Topic)this.dao.save((Object)topic);
    }

    public TopicFull save(Stakeholder stakeholder, Topic topic) {
        if (topic.getId() != null) {
            if (this.commonService.hasEditAuthority(stakeholder.getType(), stakeholder.getAlias())) {
                topic.setCategories(this.find(topic.getId()).getCategories());
                this.updateChildren(topic);
                topic = this.save(topic);
            } else {
                this.commonService.unauthorized("You are not authorized to update stakeholder with id: " + stakeholder.getId());
            }
        } else if (this.commonService.hasCreateAuthority(stakeholder.getType())) {
            topic = this.save(topic);
            this.createChildren(stakeholder, topic);
            this.addTopic(stakeholder, topic.getId());
        } else {
            this.commonService.unauthorized("You are not authorized to create a topic in stakeholder with id: " + stakeholder.getId());
        }
        return this.getFullTopic(stakeholder, topic);
    }

    public void createChildren(Stakeholder defaultStakeholder, Topic topic) {
        this.stakeholderDAO.findByDefaultIdAndCopyIsTrue(defaultStakeholder.getId()).forEach(stakeholder -> this.save(stakeholder, topic.copy()));
    }

    public void updateChildren(Topic topic) {
        this.dao.findByDefaultId(topic.getId()).forEach(child -> this.save(topic.override(child, this.find(topic.getId()))));
    }

    public TopicFull reorderCategories(Stakeholder stakeholder, Topic topic, List<String> categories) {
        if (this.commonService.hasEditAuthority(stakeholder.getType(), stakeholder.getAlias())) {
            categories.forEach(arg_0 -> ((CategoryService)this.categoryService).find(arg_0));
            if (topic.getCategories().size() == categories.size() && new HashSet(topic.getCategories()).containsAll(categories)) {
                topic.setCategories(categories);
                this.reorderChildren(stakeholder, topic, categories);
                return this.getFullTopic(stakeholder, (Topic)this.dao.save((Object)topic));
            }
            throw new NotFoundException("Some categories dont exist in the topic with id " + topic.getId());
        }
        this.commonService.unauthorized("You are not authorized to reorder categories in topic with id: " + topic.getId());
        return null;
    }

    public void reorderChildren(Stakeholder defaultStakeholder, Topic defaultTopic, List<String> defaultCategories) {
        this.stakeholderDAO.findByDefaultIdAndCopyIsTrue(defaultStakeholder.getId()).forEach(stakeholder -> this.dao.findByDefaultId(defaultTopic.getId()).stream().map(topic -> this.getFullTopic(stakeholder, topic)).forEach(topic -> this.reorderCategories(stakeholder, new Topic(topic), this.commonService.reorder(defaultCategories, topic.getCategories().stream().map(category -> category).collect(Collectors.toList())))));
    }

    public void delete(String type, Topic topic, boolean remove) {
        if (this.commonService.hasDeleteAuthority(type)) {
            this.dao.findByDefaultId(topic.getId()).forEach(child -> this.delete(type, child.getId(), remove));
            topic.getCategories().forEach(categoryId -> this.categoryService.delete(type, categoryId, false));
            if (remove) {
                this.removeTopic(topic.getId());
            }
            this.dao.delete((Object)topic);
        } else {
            this.commonService.unauthorized("Delete topic: You are not authorized to delete topic with id: " + topic.getId());
        }
    }

    public void delete(String type, String id, boolean remove) {
        Topic topic = this.find(id);
        this.delete(type, topic, remove);
    }

    public void addTopic(Stakeholder stakeholder, String id) {
        stakeholder.addTopic(id);
        this.stakeholderDAO.save((Object)stakeholder);
    }

    public void removeTopic(String id) {
        this.stakeholderDAO.findByTopic(id).forEach(stakeholder -> {
            stakeholder.removeTopic(id);
            this.stakeholderDAO.save(stakeholder);
        });
    }

    public TopicFull changeVisibility(Stakeholder stakeholder, TopicFull topic, Visibility visibility, Boolean propagate) {
        if (this.commonService.hasEditAuthority(stakeholder.getType(), stakeholder.getAlias())) {
            Stakeholder saved = this.commonService.changeVisibility(stakeholder, (Common)topic, visibility, this.stakeholderDAO);
            if (propagate.booleanValue()) {
                topic.setCategories(topic.getCategories().stream().map(category -> this.categoryService.changeVisibility(saved, category, visibility, Boolean.valueOf(true))).collect(Collectors.toList()));
            }
            if (!stakeholder.isReference()) {
                topic.update((Common)this.save(new Topic(topic)));
            }
            return topic;
        }
        this.commonService.unauthorized("Change topic visibility: You are not authorized to update topic with id: " + topic.getId());
        return null;
    }

    public TopicFull changeVisibility(Stakeholder stakeholder, Topic topic, Visibility visibility, Boolean propagate) {
        TopicFull topicFull = this.getFullTopic(stakeholder, topic);
        return this.changeVisibility(stakeholder, topicFull, visibility, propagate);
    }

    public TopicFull restoreDefault(Stakeholder stakeholder, Topic topic) {
        if (!stakeholder.isReference()) {
            stakeholder.removeOverride(topic.getId());
            return this.getFullTopic((Stakeholder)this.stakeholderDAO.save((Object)stakeholder), topic);
        }
        if (!stakeholder.isDefault()) {
            String id = topic.getId();
            List categories = topic.getCategories();
            topic = this.find(topic.getDefaultId()).copy();
            topic.setId(id);
            topic.setCategories(categories);
            return this.getFullTopic(stakeholder, this.save(topic));
        }
        return this.getFullTopic(stakeholder, topic);
    }
}

