/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.service;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoamonitorservice.dao.StakeholderDAO;
import eu.dnetlib.uoamonitorservice.dto.BuildStakeholder;
import eu.dnetlib.uoamonitorservice.dto.ManageStakeholders;
import eu.dnetlib.uoamonitorservice.dto.StakeholderFull;
import eu.dnetlib.uoamonitorservice.dto.UpdateUmbrella;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.generics.Common;
import eu.dnetlib.uoamonitorservice.generics.StakeholderGeneric;
import eu.dnetlib.uoamonitorservice.handlers.BadRequestException;
import eu.dnetlib.uoamonitorservice.primitives.Action;
import eu.dnetlib.uoamonitorservice.primitives.StakeholderType;
import eu.dnetlib.uoamonitorservice.primitives.Umbrella;
import eu.dnetlib.uoamonitorservice.primitives.Visibility;
import eu.dnetlib.uoamonitorservice.service.CommonService;
import eu.dnetlib.uoamonitorservice.service.TopicService;
import eu.dnetlib.uoamonitorservice.utils.GenericAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class StakeholderService {
    private final StakeholderDAO dao;
    private final CommonService commonService;
    private final TopicService topicService;
    private final MongoTemplate mongoTemplate;

    @Autowired
    public StakeholderService(StakeholderDAO dao, CommonService commonService, TopicService topicService, MongoTemplate mongoTemplate) {
        this.dao = dao;
        this.commonService = commonService;
        this.topicService = topicService;
        this.mongoTemplate = mongoTemplate;
    }

    public Stakeholder findByAlias(String alias) {
        return (Stakeholder)this.dao.findByAlias(alias).orElseThrow(() -> new NotFoundException("Stakeholder with alias: " + alias + " not found"));
    }

    public List<Stakeholder> findByDefaultId(String id) {
        return this.dao.findByDefaultIdAndCopyIsTrue(id);
    }

    public Stakeholder findByPath(String stakeholderId) {
        if (stakeholderId.equals("-1")) {
            return null;
        }
        return (Stakeholder)this.dao.findById((Object)stakeholderId).orElseThrow(() -> new NotFoundException("Stakeholder with id: " + stakeholderId + " not found"));
    }

    public List<String> getAllAliases(String type) {
        return this.getAll(type).stream().map(Common::getAlias).collect(Collectors.toList());
    }

    public List<Stakeholder> getAll(String type) {
        return this.dao.allStakeholders(StakeholderType.convert((String)type));
    }

    public List<Stakeholder> getAccessedStakeholders(List<Stakeholder> stakeholders, boolean isDefault) {
        return stakeholders.stream().filter(stakeholder -> this.commonService.hasAccessAuthority(stakeholder.getType(), stakeholder.getAlias(), isDefault)).collect(Collectors.toList());
    }

    public ManageStakeholders getManageStakeholders(String type) {
        ManageStakeholders manageStakeholders = new ManageStakeholders();
        StakeholderType stakeholderType = StakeholderType.convert((String)type);
        manageStakeholders.setTemplates(this.getAccessedStakeholders(this.dao.defaultStakeholders(stakeholderType), true));
        manageStakeholders.setStandalone(this.getAccessedStakeholders(this.dao.standaloneStakeholders(stakeholderType), false));
        manageStakeholders.setDependent(this.getAccessedStakeholders(this.dao.dependentStakeholders(stakeholderType), false));
        manageStakeholders.setUmbrella(this.getAccessedStakeholders(this.dao.umbrellaStakeholders(stakeholderType), false));
        return manageStakeholders;
    }

    public List<Stakeholder> getVisibleStakeholders(String type, String defaultId) {
        return this.dao.browseStakeholders(StakeholderType.convert((String)type), defaultId).stream().filter(stakeholder -> stakeholder.getVisibility() == Visibility.PUBLIC || stakeholder.getVisibility() == Visibility.RESTRICTED || this.commonService.hasAccessAuthority(stakeholder.getType(), stakeholder.getAlias(), false)).collect(Collectors.toList());
    }

    public StakeholderFull getFullStakeholder(Stakeholder stakeholder) {
        Stakeholder defaultStakeholder;
        List topics = stakeholder.getTopics().stream().map(topicId -> this.topicService.getFullTopic(stakeholder, topicId)).collect(Collectors.toList());
        if (stakeholder.isReference() && (defaultStakeholder = this.findByPath(stakeholder.getDefaultId())) != null) {
            topics = defaultStakeholder.getTopics().stream().map(topicId -> this.topicService.getFullTopic(stakeholder, topicId)).collect(Collectors.toList());
        }
        Umbrella umbrella = Umbrella.convert((Umbrella)stakeholder.getUmbrella(), (StakeholderService)this);
        return new StakeholderFull((StakeholderGeneric)stakeholder, topics, umbrella);
    }

    private List<Stakeholder> getOtherParents(String parent, String type, String id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"alias").ne((Object)parent).and("umbrella.children." + type).regex(id, "i"));
        return this.mongoTemplate.find(query, Stakeholder.class);
    }

    private Optional<Stakeholder> getActiveParent(String parent, String type, String id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"alias").is((Object)parent).and("umbrella.children." + type).regex(id, "i"));
        return Optional.ofNullable((Stakeholder)this.mongoTemplate.findOne(query, Stakeholder.class));
    }

    public StakeholderFull getFullStakeholderWithParents(Stakeholder stakeholder, String type, String parent) {
        StakeholderFull stakeholderFull = this.getFullStakeholder(stakeholder);
        if (stakeholderFull != null) {
            stakeholderFull.setParent((Stakeholder)this.getActiveParent(parent, type, stakeholder.getId()).orElseThrow(() -> new NotFoundException("Stakeholder with alias: " + stakeholder.getAlias() + " not found in stakeholder " + parent)));
            stakeholderFull.setOtherParents(this.getOtherParents(parent, type, stakeholder.getId()));
        }
        return stakeholderFull;
    }

    public Stakeholder generateAlias(Stakeholder stakeholder) {
        return this.generateAlias(stakeholder, null);
    }

    public Stakeholder generateAlias(Stakeholder stakeholder, String field) {
        Object alias = stakeholder.getAlias();
        if (field != null) {
            try {
                alias = Objects.requireNonNull(GenericAccessor.getField((Object)stakeholder, (String)field)).toString().toLowerCase();
                alias = Objects.requireNonNull(alias).replaceAll("[^a-z0-9-]", "-");
                alias = ((String)Objects.requireNonNull(alias)).replaceAll("-+", "-");
                alias = ((String)Objects.requireNonNull(alias)).replaceAll("^-+|-+$", "-");
            }
            catch (NullPointerException e) {
                throw new BadRequestException("Cannot generate alias with field " + field + " for stakeholder: " + stakeholder.getName());
            }
        }
        if (alias == null) {
            throw new BadRequestException("Cannot generate alias for stakeholder: " + stakeholder.getName());
        }
        int duplicates = 1;
        while (this.dao.findByAlias((String)alias).isPresent()) {
            alias = (String)alias + duplicates;
            ++duplicates;
        }
        stakeholder.setAlias((String)alias);
        return stakeholder;
    }

    public List<Stakeholder> buildStakeholders(BuildStakeholder buildStakeholder) {
        List<Object> stakeholders = new ArrayList<Stakeholder>();
        if (buildStakeholder.isMultiBuild()) {
            stakeholders = buildStakeholder.getIndexFields().stream().map(fields -> {
                Stakeholder stakeholder = new Stakeholder(buildStakeholder.getStakeholder());
                stakeholder.setIndex_id((String)fields.get(stakeholder.getIndex_id()));
                stakeholder.setIndex_name((String)fields.get(stakeholder.getIndex_name()));
                stakeholder.setIndex_shortName((String)fields.get(stakeholder.getIndex_shortName()));
                stakeholder.setName(stakeholder.getIndex_name());
                stakeholder = this.generateAlias(stakeholder, stakeholder.getAlias());
                return stakeholder;
            }).toList();
        } else {
            stakeholders.add(buildStakeholder.getStakeholder());
        }
        stakeholders.forEach(stakeholder -> stakeholder.setStandalone(buildStakeholder.isStandalone()));
        if (buildStakeholder.isUmbrella()) {
            stakeholders.forEach(stakeholder -> stakeholder.setUmbrella(new Umbrella()));
        } else if (buildStakeholder.getParent() != null) {
            Stakeholder umbrellaStakeholder = this.findByPath(buildStakeholder.getParent());
            stakeholders.forEach(stakeholder -> this.updateUmbrella(umbrellaStakeholder, new UpdateUmbrella(stakeholder.getType(), Action.ADD, stakeholder.getId())));
        }
        return stakeholders.stream().map(stakeholder -> this.buildStakeholder(stakeholder, buildStakeholder.getCopyId())).toList();
    }

    public Stakeholder buildStakeholder(Stakeholder stakeholder, String copyId) {
        if (stakeholder.getDefaultId() == null) {
            stakeholder.setCopy(false);
            if (copyId == null) {
                stakeholder.setTopics(new ArrayList());
            } else {
                Stakeholder copyFrom = this.findByPath(copyId);
                stakeholder.setTopics(copyFrom.getTopics().stream().map(arg_0 -> ((TopicService)this.topicService).copy(arg_0)).collect(Collectors.toList()));
            }
        } else {
            Stakeholder defaultStakeholder;
            stakeholder = this.generateAlias(stakeholder);
            stakeholder.setTopics(new ArrayList());
            if (stakeholder.isCopy() && (defaultStakeholder = this.findByPath(stakeholder.getDefaultId())) != null) {
                stakeholder.setTopics(defaultStakeholder.getTopics().stream().map(arg_0 -> ((TopicService)this.topicService).build(arg_0)).collect(Collectors.toList()));
            }
        }
        return this.save(stakeholder);
    }

    public Stakeholder save(Stakeholder stakeholder) {
        if (stakeholder.getId() != null) {
            Stakeholder old = this.findByPath(stakeholder.getId());
            if (stakeholder.getOverrides() == null) {
                stakeholder.setOverrides(old.getOverrides());
            }
            stakeholder.setUmbrella(old.getUmbrella());
            stakeholder.setStandalone(old.isStandalone());
            stakeholder.setDefaultId(old.getDefaultId());
            if (stakeholder.isReference()) {
                stakeholder.getTopics().forEach(topic -> this.topicService.delete(stakeholder.getType(), topic, false));
                stakeholder.setTopics(new ArrayList());
            } else {
                if (old.getTopics().isEmpty() && old.getDefaultId() != null) {
                    Stakeholder defaultStakeholder = this.findByPath(stakeholder.getDefaultId());
                    if (defaultStakeholder != null) {
                        stakeholder.setTopics(defaultStakeholder.getTopics().stream().map(arg_0 -> ((TopicService)this.topicService).build(arg_0)).collect(Collectors.toList()));
                    }
                    stakeholder.setOverrides(new HashMap());
                }
                stakeholder.getTopics().forEach(arg_0 -> ((TopicService)this.topicService).find(arg_0));
            }
        }
        return (Stakeholder)this.dao.save((Object)stakeholder.validate());
    }

    public StakeholderFull reorderTopics(Stakeholder stakeholder, List<String> topics) {
        if (this.commonService.hasEditAuthority(stakeholder.getType(), stakeholder.getAlias())) {
            topics.forEach(arg_0 -> ((TopicService)this.topicService).find(arg_0));
            if (stakeholder.getTopics().size() == topics.size() && new HashSet(stakeholder.getTopics()).containsAll(topics)) {
                stakeholder.setTopics(topics);
                this.reorderChildren(stakeholder, topics);
                return this.getFullStakeholder((Stakeholder)this.dao.save((Object)stakeholder));
            }
            throw new NotFoundException("Some topics dont exist in the stakeholder with id " + stakeholder.getId());
        }
        this.commonService.unauthorized("You are not authorized to reorder topics in stakeholder with id: " + stakeholder.getId());
        return null;
    }

    public void reorderChildren(Stakeholder defaultStakeholder, List<String> defaultTopics) {
        this.dao.findByDefaultIdAndCopyIsTrue(defaultStakeholder.getId()).stream().map(arg_0 -> this.getFullStakeholder(arg_0)).forEach(stakeholder -> this.reorderTopics(new Stakeholder(stakeholder, this), this.commonService.reorder(defaultTopics, stakeholder.getTopics().stream().map(topic -> topic).collect(Collectors.toList()))));
    }

    public String delete(String id) {
        Stakeholder stakeholder = this.findByPath(id);
        if (this.commonService.hasDeleteAuthority(stakeholder.getType())) {
            this.dao.umbrellaStakeholders().forEach(umbrellaStakeholder -> {
                StakeholderType type = StakeholderType.valueOf((String)stakeholder.getType());
                List ids = (List)umbrellaStakeholder.getUmbrella().getChildren().get(type);
                if (ids != null && ids.contains(stakeholder.getId())) {
                    this.removeChild(umbrellaStakeholder.getId(), StakeholderType.valueOf((String)stakeholder.getType()), stakeholder.getId());
                }
            });
            this.dao.findByDefaultIdAndCopyIsTrue(stakeholder.getId()).forEach(child -> this.delete(child.getId()));
            stakeholder.getTopics().forEach(topicId -> this.topicService.delete(stakeholder.getType(), topicId, false));
            this.dao.deleteById((Object)id);
            return stakeholder.getAlias();
        }
        this.commonService.unauthorized("Delete stakeholder: You are not authorized to delete stakeholder with id: " + id);
        return null;
    }

    public StakeholderFull changeVisibility(StakeholderFull stakeholder, Visibility visibility, Boolean propagate) {
        if (this.commonService.hasEditAuthority(stakeholder.getType(), stakeholder.getAlias())) {
            stakeholder.setVisibility(visibility);
            Stakeholder toSave = new Stakeholder(stakeholder, this);
            if (propagate.booleanValue()) {
                stakeholder.setTopics(stakeholder.getTopics().stream().map(topic -> this.topicService.changeVisibility(toSave, topic, visibility, Boolean.valueOf(true))).collect(Collectors.toList()));
            }
            return this.getFullStakeholder(this.save(toSave));
        }
        this.commonService.unauthorized("Change stakeholder visibility: You are not authorized to update stakeholder with id: " + stakeholder.getId());
        return null;
    }

    public StakeholderFull changeVisibility(Stakeholder stakeholder, Visibility visibility, Boolean propagate) {
        StakeholderFull stakeholderFull = this.getFullStakeholder(stakeholder);
        return this.changeVisibility(stakeholderFull, visibility, propagate);
    }

    public Umbrella<Stakeholder> updateUmbrella(Stakeholder stakeholder, UpdateUmbrella update) {
        if (this.commonService.hasEditAuthority(stakeholder.getType(), stakeholder.getAlias())) {
            if (update.getAction().equals((Object)Action.ADD)) {
                if (update.getChild() != null) {
                    return this.addChild(stakeholder.getId(), update.getType(), update.getChild());
                }
                return this.addType(stakeholder.getId(), update.getType());
            }
            if (update.getAction().equals((Object)Action.REMOVE)) {
                if (update.getChild() != null) {
                    return this.removeChild(stakeholder.getId(), update.getType(), update.getChild());
                }
                return this.removeType(stakeholder.getId(), update.getType());
            }
            if (update.getAction().equals((Object)Action.UPDATE)) {
                if (update.getType() != null) {
                    return this.updateChildren(stakeholder.getId(), update.getType(), update.getChildren());
                }
                return this.updateTypes(stakeholder.getId(), update.getTypes());
            }
        } else {
            this.commonService.unauthorized("You are not authorized to update umbrella in stakeholder with id: " + stakeholder.getId());
        }
        return null;
    }

    public Umbrella<Stakeholder> addType(String id, StakeholderType type) {
        Stakeholder stakeholder = this.findByPath(id);
        Umbrella umbrella = (Umbrella)stakeholder.getUmbrellaOptional().orElseThrow(() -> new NotFoundException("Umbrella not found in the stakeholder with id " + id));
        if (umbrella.addType(type)) {
            stakeholder.setUmbrella(umbrella);
            return this.getFullStakeholder((Stakeholder)this.dao.save((Object)stakeholder)).getUmbrella();
        }
        throw new BadRequestException("Cannot add type: " + type + " to stakeholder with id " + id);
    }

    public Umbrella<Stakeholder> removeType(String id, StakeholderType type) {
        Stakeholder stakeholder = this.findByPath(id);
        Umbrella umbrella = (Umbrella)stakeholder.getUmbrellaOptional().orElseThrow(() -> new NotFoundException("Umbrella not found in the stakeholder with id " + id));
        if (umbrella.removeType(type)) {
            stakeholder.setUmbrella(umbrella);
            return this.getFullStakeholder((Stakeholder)this.dao.save((Object)stakeholder)).getUmbrella();
        }
        throw new BadRequestException("Cannot add type: " + type + " to stakeholder with id " + id);
    }

    public Umbrella<Stakeholder> addChild(String id, StakeholderType type, String childId) {
        Stakeholder stakeholder = this.findByPath(id);
        Umbrella umbrella = (Umbrella)stakeholder.getUmbrellaOptional().orElseThrow(() -> new NotFoundException("Umbrella not found in the stakeholder with id " + id));
        Stakeholder child = this.findByPath(childId);
        if (child.getType().equals(type.name()) && umbrella.addChild(type, (Object)childId)) {
            stakeholder.setUmbrella(umbrella);
            return this.getFullStakeholder((Stakeholder)this.dao.save((Object)stakeholder)).getUmbrella();
        }
        throw new BadRequestException("Cannot add child: " + childId + " to stakeholder with id " + id);
    }

    public Umbrella<Stakeholder> removeChild(String id, StakeholderType type, String childId) {
        Stakeholder stakeholder = this.findByPath(id);
        Umbrella umbrella = (Umbrella)stakeholder.getUmbrellaOptional().orElseThrow(() -> new NotFoundException("Umbrella not found in the stakeholder with id " + id));
        Stakeholder child = this.findByPath(childId);
        if (child.getType().equals(type.name()) && umbrella.removeChild(type, (Object)childId)) {
            stakeholder.setUmbrella(umbrella);
            return this.getFullStakeholder((Stakeholder)this.dao.save((Object)stakeholder)).getUmbrella();
        }
        throw new BadRequestException("Cannot remove child: " + childId + " to stakeholder with id " + id);
    }

    public Umbrella<Stakeholder> updateTypes(String id, List<StakeholderType> types) {
        Stakeholder stakeholder = this.findByPath(id);
        Umbrella umbrella = (Umbrella)stakeholder.getUmbrellaOptional().orElseThrow(() -> new NotFoundException("Umbrella not found in the stakeholder with id " + id));
        if (stakeholder.getUmbrella().update(types)) {
            stakeholder.setUmbrella(umbrella);
            return this.getFullStakeholder((Stakeholder)this.dao.save((Object)stakeholder)).getUmbrella();
        }
        throw new BadRequestException("Cannot update types in umbrella of stakeholder with id " + id);
    }

    public Umbrella<Stakeholder> updateChildren(String id, StakeholderType type, List<String> children) {
        Stakeholder stakeholder = this.findByPath(id);
        Umbrella umbrella = (Umbrella)stakeholder.getUmbrellaOptional().orElseThrow(() -> new NotFoundException("Umbrella not found in the stakeholder with id " + id));
        if (stakeholder.getUmbrella().update(type, children)) {
            stakeholder.setUmbrella(umbrella);
            return this.getFullStakeholder((Stakeholder)this.dao.save((Object)stakeholder)).getUmbrella();
        }
        throw new BadRequestException("Cannot update children of " + type + " in umbrella of stakeholder with id " + id);
    }
}

