/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.service;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoamonitorservice.dao.CategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.IndicatorDAO;
import eu.dnetlib.uoamonitorservice.dao.SectionDAO;
import eu.dnetlib.uoamonitorservice.dao.StakeholderDAO;
import eu.dnetlib.uoamonitorservice.dao.SubCategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.TopicDAO;
import eu.dnetlib.uoamonitorservice.entities.Indicator;
import eu.dnetlib.uoamonitorservice.entities.Section;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.generics.Common;
import eu.dnetlib.uoamonitorservice.handlers.PathNotValidException;
import eu.dnetlib.uoamonitorservice.primitives.Visibility;
import eu.dnetlib.uoamonitorservice.service.CommonService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IndicatorService {
    private final StakeholderDAO stakeholderDAO;
    private final TopicDAO topicDAO;
    private final CategoryDAO categoryDAO;
    private final SubCategoryDAO subCategoryDAO;
    private final SectionDAO sectionDAO;
    private final IndicatorDAO dao;
    private final CommonService commonService;

    @Autowired
    public IndicatorService(StakeholderDAO stakeholderDAO, TopicDAO topicDAO, CategoryDAO categoryDAO, SubCategoryDAO subCategoryDAO, SectionDAO sectionDAO, IndicatorDAO dao, CommonService commonService) {
        this.stakeholderDAO = stakeholderDAO;
        this.topicDAO = topicDAO;
        this.categoryDAO = categoryDAO;
        this.subCategoryDAO = subCategoryDAO;
        this.sectionDAO = sectionDAO;
        this.dao = dao;
        this.commonService = commonService;
    }

    public Indicator find(String id) {
        return (Indicator)this.dao.findById((Object)id).orElseThrow(() -> new NotFoundException("Indicator with id: " + id + " not found"));
    }

    public Indicator findByPath(Section section, String indicatorId) {
        if (!section.getIndicators().contains(indicatorId)) {
            throw new PathNotValidException("Indicator with id: " + indicatorId + " not found in Section: " + section.getId());
        }
        return (Indicator)this.dao.findById((Object)indicatorId).orElseThrow(() -> new NotFoundException("Indicator with id: " + indicatorId + " not found"));
    }

    public Indicator getIndicator(Stakeholder stakeholder, String id) {
        Indicator indicator = this.find(id);
        indicator.override(stakeholder);
        if (this.commonService.hasVisibilityAuthority(stakeholder.getType(), stakeholder.getAlias(), (Common)indicator)) {
            return indicator;
        }
        return null;
    }

    public String build(String id) {
        return this.save(this.find(id).copy()).getId();
    }

    public String copy(String id) {
        Indicator copy = new Indicator(this.find(id));
        copy.setId(null);
        return this.save(copy).getId();
    }

    public Indicator save(Indicator indicator) {
        return (Indicator)this.dao.save((Object)indicator);
    }

    public Indicator save(Stakeholder stakeholder, Section section, Indicator indicator) {
        if (indicator.getId() != null) {
            if (this.commonService.hasEditAuthority(stakeholder.getType(), stakeholder.getAlias())) {
                this.updateChildren(indicator);
                indicator = this.save(indicator);
            } else {
                this.commonService.unauthorized("You are not authorized to update stakeholder with id: " + stakeholder.getId());
            }
        } else if (this.commonService.hasCreateAuthority(stakeholder.getType())) {
            indicator = this.save(indicator);
            this.createChildren(section, indicator);
            this.addIndicator(section, indicator.getId());
        } else {
            this.commonService.unauthorized("You are not authorized to create an indicator in stakeholder with id: " + stakeholder.getId());
        }
        return indicator;
    }

    public void createChildren(Section defaultSection, Indicator indicator) {
        this.sectionDAO.findByDefaultId(defaultSection.getId()).forEach(section -> {
            List subCategories = this.subCategoryDAO.findByNumber(section.getId());
            subCategories.addAll(this.subCategoryDAO.findByChart(section.getId()));
            subCategories.forEach(subCategory -> this.categoryDAO.findBySubCategory(subCategory.getId()).forEach(category -> this.topicDAO.findByCategory(category.getId()).forEach(topic -> this.stakeholderDAO.findByTopic(topic.getId()).forEach(stakeholder -> this.save(stakeholder, section, indicator.copy())))));
        });
    }

    public void updateChildren(Indicator indicator) {
        this.dao.findByDefaultId(indicator.getId()).forEach(child -> this.save(indicator.override(child, this.find(indicator.getId()))));
    }

    public void delete(String type, Indicator indicator, boolean remove) {
        if (this.commonService.hasDeleteAuthority(type)) {
            this.dao.findByDefaultId(indicator.getId()).forEach(child -> this.delete(type, child.getId(), remove));
            if (remove) {
                this.removeIndicator(indicator.getId());
            }
            this.dao.delete((Object)indicator);
        } else {
            this.commonService.unauthorized("Delete indicator: You are not authorized to delete indicator with id: " + indicator.getId());
        }
    }

    public void delete(String type, String id, boolean remove) {
        Indicator indicator = this.find(id);
        this.delete(type, indicator, remove);
    }

    public void addIndicator(Section section, String id) {
        section.addIndicator(id);
        this.sectionDAO.save((Object)section);
    }

    public void removeIndicator(String id) {
        this.sectionDAO.findByIndicator(id).forEach(section -> {
            section.removeIndicator(id);
            this.sectionDAO.save(section);
        });
    }

    public Indicator changeVisibility(Stakeholder stakeholder, Indicator indicator, Visibility visibility) {
        if (this.commonService.hasEditAuthority(stakeholder.getType(), stakeholder.getAlias())) {
            if (!(stakeholder = this.commonService.changeVisibility(stakeholder, (Common)indicator, visibility, this.stakeholderDAO)).isReference()) {
                indicator = this.save(indicator);
            }
            return indicator;
        }
        this.commonService.unauthorized("Change section visibility: You are not authorized to update section with id: " + indicator.getId());
        return null;
    }
}

