/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.service;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.ForbiddenException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.UnauthorizedException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import eu.dnetlib.uoamonitorservice.dao.StakeholderDAO;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.generics.Common;
import eu.dnetlib.uoamonitorservice.primitives.Visibility;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonService {
    AuthorizationService authorizationService;

    @Autowired
    public CommonService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public boolean hasAccessAuthority(String type, String alias, boolean isDefault) {
        if (this.authorizationService.isPortalAdmin() || this.authorizationService.isCurator(type)) {
            return true;
        }
        if (!isDefault) {
            return this.authorizationService.isManager(type, alias);
        }
        return false;
    }

    public boolean hasDeleteAuthority(String type) {
        return this.authorizationService.isPortalAdmin() || this.authorizationService.isCurator(type);
    }

    public boolean hasCreateAuthority(String type) {
        return this.authorizationService.isPortalAdmin() || this.authorizationService.isCurator(type);
    }

    public boolean hasEditAuthority(String type, String alias) {
        return this.authorizationService.isPortalAdmin() || this.authorizationService.isCurator(type) || this.authorizationService.isManager(type, alias);
    }

    public boolean hasVisibilityAuthority(String type, String alias, Common common) {
        if (this.authorizationService.isPortalAdmin() || this.authorizationService.isCurator(type) || this.authorizationService.isManager(type, alias)) {
            return true;
        }
        if (this.authorizationService.isMember(type, alias) && common.getVisibility() != Visibility.PRIVATE) {
            return true;
        }
        return common.getVisibility() == Visibility.PUBLIC;
    }

    public void unauthorized(String message) {
        if (this.authorizationService.getAaiId() != null) {
            throw new ForbiddenException(message);
        }
        throw new UnauthorizedException(message);
    }

    public List<String> reorder(List<String> defaultIds, List<Common> commons) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < commons.size(); ++i) {
            if (defaultIds.contains(commons.get(i).getDefaultId())) continue;
            map.put(((Common)commons.get(i)).getId(), i);
        }
        commons = commons.stream().filter(common -> defaultIds.contains(common.getDefaultId())).collect(Collectors.toList());
        commons.sort(Comparator.comparingInt(common -> defaultIds.indexOf(common.getDefaultId())));
        List<String> ids = commons.stream().map(Common::getId).collect(Collectors.toList());
        map.keySet().forEach(key -> ids.add((Integer)map.get(key), (String)key));
        return ids;
    }

    public Stakeholder changeVisibility(Stakeholder stakeholder, Common common, Visibility visibility, StakeholderDAO stakeholderDAO) {
        if (!common.getVisibility().equals((Object)visibility)) {
            common.setVisibility(visibility);
            if (stakeholder.isReference()) {
                stakeholder.setOverride(common.getId(), "visibility", (Object)visibility);
                stakeholder = (Stakeholder)stakeholderDAO.save((Object)stakeholder);
            }
        }
        return stakeholder;
    }
}

