/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.service;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoamonitorservice.dao.CategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.StakeholderDAO;
import eu.dnetlib.uoamonitorservice.dao.TopicDAO;
import eu.dnetlib.uoamonitorservice.dto.CategoryFull;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.generics.CategoryGeneric;
import eu.dnetlib.uoamonitorservice.generics.Common;
import eu.dnetlib.uoamonitorservice.handlers.PathNotValidException;
import eu.dnetlib.uoamonitorservice.primitives.Visibility;
import eu.dnetlib.uoamonitorservice.service.CommonService;
import eu.dnetlib.uoamonitorservice.service.SubCategoryService;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryService {
    private final StakeholderDAO stakeholderDAO;
    private final TopicDAO topicDAO;
    private final CategoryDAO dao;
    private final SubCategoryService subCategoryService;
    private final CommonService commonService;

    @Autowired
    public CategoryService(StakeholderDAO stakeholderDAO, TopicDAO topicDAO, CategoryDAO dao, SubCategoryService subCategoryService, CommonService commonService) {
        this.stakeholderDAO = stakeholderDAO;
        this.topicDAO = topicDAO;
        this.dao = dao;
        this.subCategoryService = subCategoryService;
        this.commonService = commonService;
    }

    public Category find(String id) {
        return (Category)this.dao.findById((Object)id).orElseThrow(() -> new NotFoundException("Category with id: " + id + " not found"));
    }

    public Category findByPath(Topic topic, String categoryId) {
        if (!topic.getCategories().contains(categoryId)) {
            throw new PathNotValidException("Category with id: " + categoryId + " not found in Topic: " + topic.getId());
        }
        return (Category)this.dao.findById((Object)categoryId).orElseThrow(() -> new NotFoundException("Category with id: " + categoryId + " not found"));
    }

    public CategoryFull getFullCategory(Stakeholder stakeholder, Category category) {
        category.override(stakeholder);
        if (this.commonService.hasVisibilityAuthority(stakeholder.getType(), stakeholder.getAlias(), (Common)category)) {
            return new CategoryFull((CategoryGeneric)category, category.getSubCategories().stream().map(subCategoryId -> this.subCategoryService.getFullSubCategory(stakeholder, subCategoryId)).collect(Collectors.toList()));
        }
        return null;
    }

    public CategoryFull getFullCategory(Stakeholder stakeholder, String categoryId) {
        Category category = this.find(categoryId);
        return this.getFullCategory(stakeholder, category);
    }

    public String build(String id) {
        Category category = this.find(id);
        Category copy = category.copy();
        copy.setSubCategories(category.getSubCategories().stream().map(arg_0 -> ((SubCategoryService)this.subCategoryService).build(arg_0)).collect(Collectors.toList()));
        return this.save(copy).getId();
    }

    public String copy(String id) {
        Category category = this.find(id);
        Category copy = new Category(category);
        copy.setId(null);
        copy.setSubCategories(category.getSubCategories().stream().map(arg_0 -> ((SubCategoryService)this.subCategoryService).copy(arg_0)).collect(Collectors.toList()));
        return this.save(copy).getId();
    }

    public Category save(Category category) {
        if (category.getId() != null) {
            category.setSubCategories(this.find(category.getId()).getSubCategories());
        }
        category.getSubCategories().forEach(arg_0 -> ((SubCategoryService)this.subCategoryService).find(arg_0));
        return (Category)this.dao.save((Object)category);
    }

    public CategoryFull save(Stakeholder stakeholder, Topic topic, Category category) {
        return this.save(stakeholder, topic, category, true);
    }

    public CategoryFull save(Stakeholder stakeholder, Topic topic, Category category, boolean createOverview) {
        if (category.getId() != null) {
            if (this.commonService.hasEditAuthority(stakeholder.getType(), stakeholder.getAlias())) {
                category.setSubCategories(this.find(category.getId()).getSubCategories());
                this.updateChildren(category);
                category = this.save(category);
            } else {
                this.commonService.unauthorized("You are not authorized to update stakeholder with id: " + stakeholder.getId());
            }
        } else if (this.commonService.hasCreateAuthority(stakeholder.getType())) {
            category = this.save(category);
            this.createChildren(topic, category);
            if (createOverview) {
                this.subCategoryService.save(stakeholder, category, category.createOverview());
            }
            this.addCategory(topic, category.getId());
        } else {
            this.commonService.unauthorized("You are not authorized to create a category in stakeholder with id: " + stakeholder.getId());
        }
        return this.getFullCategory(stakeholder, category);
    }

    public void createChildren(Topic defaultTopic, Category category) {
        this.topicDAO.findByDefaultId(defaultTopic.getId()).forEach(topic -> this.stakeholderDAO.findByTopic(topic.getId()).forEach(stakeholder -> this.save(stakeholder, topic, category.copy(), false)));
    }

    public void updateChildren(Category category) {
        this.dao.findByDefaultId(category.getId()).forEach(child -> this.save(category.override(child, this.find(category.getId()))));
    }

    public CategoryFull reorderSubCategories(Stakeholder stakeholder, Category category, List<String> subcategories) {
        if (this.commonService.hasEditAuthority(stakeholder.getType(), stakeholder.getAlias())) {
            subcategories.forEach(arg_0 -> ((SubCategoryService)this.subCategoryService).find(arg_0));
            if (category.getSubCategories().size() == subcategories.size() && new HashSet(category.getSubCategories()).containsAll(subcategories)) {
                category.setSubCategories(subcategories);
                this.reorderChildren(stakeholder, category, subcategories);
                return this.getFullCategory(stakeholder, (Category)this.dao.save((Object)category));
            }
            throw new NotFoundException("Some subCategories dont exist in the category with id " + category.getId());
        }
        this.commonService.unauthorized("You are not authorized to reorder subCategories in category with id: " + category.getId());
        return null;
    }

    public void reorderChildren(Stakeholder defaultStakeholder, Category defaultCategory, List<String> defaultSubCategories) {
        this.stakeholderDAO.findByDefaultIdAndCopyIsTrue(defaultStakeholder.getId()).forEach(stakeholder -> this.dao.findByDefaultId(defaultCategory.getId()).stream().map(category -> this.getFullCategory(stakeholder, category)).forEach(category -> this.reorderSubCategories(stakeholder, new Category(category), this.commonService.reorder(defaultSubCategories, category.getSubCategories().stream().map(subCategory -> subCategory).collect(Collectors.toList())))));
    }

    public void delete(String type, Category category, boolean remove) {
        if (this.commonService.hasDeleteAuthority(type)) {
            this.dao.findByDefaultId(category.getId()).forEach(child -> this.delete(type, child.getId(), remove));
            category.getSubCategories().forEach(subcategoryId -> this.subCategoryService.delete(type, subcategoryId, false));
            if (remove) {
                this.removeCategory(category.getId());
            }
            this.dao.delete((Object)category);
        } else {
            this.commonService.unauthorized("Delete category: You are not authorized to delete category with id: " + category.getId());
        }
    }

    public void delete(String type, String id, boolean remove) {
        Category category = this.find(id);
        this.delete(type, category, remove);
    }

    public void addCategory(Topic topic, String id) {
        topic.addCategory(id);
        this.topicDAO.save((Object)topic);
    }

    public void removeCategory(String id) {
        this.topicDAO.findByCategory(id).forEach(topic -> {
            topic.removeCategory(id);
            this.topicDAO.save(topic);
        });
    }

    public CategoryFull changeVisibility(Stakeholder stakeholder, CategoryFull category, Visibility visibility, Boolean propagate) {
        if (this.commonService.hasEditAuthority(stakeholder.getType(), stakeholder.getAlias())) {
            Stakeholder saved = this.commonService.changeVisibility(stakeholder, (Common)category, visibility, this.stakeholderDAO);
            if (propagate.booleanValue()) {
                category.setSubCategories(category.getSubCategories().stream().map(subCategory -> this.subCategoryService.changeVisibility(saved, subCategory, visibility, Boolean.valueOf(true))).collect(Collectors.toList()));
            }
            if (!stakeholder.isReference()) {
                category.update((Common)this.save(new Category(category)));
            }
            return category;
        }
        this.commonService.unauthorized("Change category visibility: You are not authorized to update category with id: " + category.getId());
        return null;
    }

    public CategoryFull changeVisibility(Stakeholder stakeholder, Category category, Visibility visibility, Boolean propagate) {
        CategoryFull categoryFull = this.getFullCategory(stakeholder, category);
        return this.changeVisibility(stakeholder, categoryFull, visibility, propagate);
    }

    public CategoryFull restoreDefault(Stakeholder stakeholder, Category category) {
        if (!stakeholder.isReference()) {
            stakeholder.removeOverride(category.getId());
            return this.getFullCategory((Stakeholder)this.stakeholderDAO.save((Object)stakeholder), category);
        }
        if (!stakeholder.isDefault()) {
            String id = category.getId();
            List subCategories = category.getSubCategories();
            category = this.find(category.getDefaultId()).copy();
            category.setId(id);
            category.setSubCategories(subCategories);
            return this.getFullCategory(stakeholder, this.save(category));
        }
        return this.getFullCategory(stakeholder, category);
    }
}

