/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.generics;

import com.fasterxml.jackson.annotation.JsonIgnore;
import eu.dnetlib.uoamonitorservice.generics.Common;
import eu.dnetlib.uoamonitorservice.primitives.Locale;
import eu.dnetlib.uoamonitorservice.primitives.StakeholderType;
import eu.dnetlib.uoamonitorservice.primitives.Umbrella;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StakeholderGeneric<T, S>
extends Common {
    protected StakeholderType type;
    protected Date projectUpdateDate = null;
    protected String index_id;
    protected String index_name;
    protected String index_shortName;
    protected String statsProfile = "monitor";
    protected String logoUrl;
    protected boolean isUpload = false;
    protected Locale locale = Locale.EU;
    protected String funderType;
    protected Boolean standalone = true;
    protected Boolean copy;
    protected List<T> topics = new ArrayList();
    protected Umbrella<S> umbrella;
    protected Map<String, Map<String, Object>> overrides;

    public StakeholderGeneric() {
    }

    public StakeholderGeneric(StakeholderGeneric stakeholder) {
        super((Common)stakeholder);
        this.setType(stakeholder.getType());
        this.projectUpdateDate = stakeholder.getProjectUpdateDate();
        this.index_id = stakeholder.getIndex_id();
        this.index_name = stakeholder.getIndex_name();
        this.index_shortName = stakeholder.getIndex_shortName();
        this.statsProfile = stakeholder.getStatsProfile();
        this.logoUrl = stakeholder.getLogoUrl();
        this.isUpload = stakeholder.getIsUpload();
        this.setLocale(stakeholder.getLocale());
        this.funderType = stakeholder.getFunderType();
        this.copy = stakeholder.isCopy();
        if (!this.copy.booleanValue()) {
            this.overrides = new HashMap();
        }
        this.standalone = stakeholder.isStandalone();
    }

    public String getType() {
        if (this.type == null) {
            return null;
        }
        return this.type.name();
    }

    public void setType(String type) {
        this.type = StakeholderType.convert((String)type);
    }

    public Date getProjectUpdateDate() {
        return this.projectUpdateDate;
    }

    public void setProjectUpdateDate(Date projectUpdateDate) {
        this.projectUpdateDate = projectUpdateDate;
    }

    public String getIndex_id() {
        return this.index_id;
    }

    public void setIndex_id(String index_id) {
        this.index_id = index_id;
    }

    public String getIndex_name() {
        return this.index_name;
    }

    public void setIndex_name(String index_name) {
        this.index_name = index_name;
    }

    public String getIndex_shortName() {
        return this.index_shortName;
    }

    public void setIndex_shortName(String index_shortName) {
        this.index_shortName = index_shortName;
    }

    public String getStatsProfile() {
        return this.statsProfile;
    }

    public void setStatsProfile(String statsProfile) {
        this.statsProfile = statsProfile;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public boolean getIsUpload() {
        return this.isUpload;
    }

    public void setIsUpload(boolean isUpload) {
        this.isUpload = isUpload;
    }

    public String getLocale() {
        return this.locale.label;
    }

    public void setLocale(String label) {
        Locale locale = null;
        for (Locale l : Locale.values()) {
            if (!l.label.equals(label)) continue;
            locale = l;
        }
        this.locale = locale;
    }

    public String getFunderType() {
        return this.funderType;
    }

    public void setFunderType(String funderType) {
        this.funderType = funderType;
    }

    public boolean isStandalone() {
        if (this.standalone == null) {
            this.standalone = true;
        }
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public boolean isCopy() {
        if (this.copy == null) {
            this.copy = this.defaultId != null;
        }
        return this.copy;
    }

    public boolean isReference() {
        return this.copy == false && this.defaultId != null;
    }

    public boolean isDefault() {
        return this.copy == false && this.defaultId == null;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public List<T> getTopics() {
        return this.topics;
    }

    public void setTopics(List<T> topics) {
        this.topics = topics;
    }

    @JsonIgnore
    public Map<String, Map<String, Object>> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(Map<String, Map<String, Object>> overrides) {
        this.overrides = overrides;
    }

    public Umbrella<S> getUmbrella() {
        return this.umbrella;
    }

    @JsonIgnore
    public Optional<Umbrella<S>> getUmbrellaOptional() {
        return Optional.ofNullable(this.umbrella);
    }

    public void setUmbrella(Umbrella<S> umbrella) {
        this.umbrella = umbrella;
    }

    public Map<String, Object> getOverride(String id) {
        if (this.overrides == null) {
            this.overrides = new HashMap();
        }
        return this.overrides.getOrDefault(id, new HashMap());
    }

    public <V> void setOverride(String id, String field, V value) {
        if (!this.copy.booleanValue() && this.defaultId != null) {
            Map override = this.getOverride(id);
            override.put(field, value);
            this.overrides.put(id, override);
        }
    }

    public void removeOverride(String id) {
        if (this.overrides != null) {
            this.overrides.remove(id);
        }
    }
}

