/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.generics;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.primitives.Visibility;
import eu.dnetlib.uoamonitorservice.utils.GenericAccessor;
import java.util.Date;
import java.util.Map;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.annotation.Transient;

public class Common {
    @Id
    @JsonProperty(value="_id")
    protected String id;
    @CreatedDate
    protected Date creationDate;
    @LastModifiedDate
    protected Date updateDate;
    protected String defaultId;
    protected String name;
    protected String description;
    protected String alias;
    protected String icon;
    protected Visibility visibility;
    @Transient
    protected boolean override;

    protected Common() {
    }

    protected Common(Common common) {
        this.id = common.getId();
        this.creationDate = common.getCreationDate();
        this.updateDate = common.getUpdateDate();
        this.defaultId = common.getDefaultId();
        this.name = common.getName();
        this.description = common.getDescription();
        this.alias = common.getAlias();
        this.icon = common.getIcon();
        this.setVisibility(common.getVisibility());
        this.override = common.isOverride();
    }

    public void update(Common common) {
        this.id = common.getId();
        this.creationDate = common.getCreationDate();
        this.updateDate = common.getUpdateDate();
    }

    public Common override(Common common, Common old) {
        if (this.getName() != null && !this.getName().equals(common.getName()) && (old.getName() == null || old.getName().equals(common.getName()))) {
            common.setName(this.getName());
            common.setAlias(this.getAlias());
        }
        if (this.getDescription() != null && !this.getDescription().equals(common.getDescription()) && (old.getDescription() == null || old.getDescription().equals(common.getDescription()))) {
            common.setDescription(this.getDescription());
        }
        if (this.getIcon() != null && !this.getIcon().equals(common.getIcon()) && (old.getIcon() == null || old.getIcon().equals(common.getIcon()))) {
            common.setIcon(this.getIcon());
        }
        return common;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getDefaultId() {
        return this.defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void override(Stakeholder stakeholder) {
        Map override = stakeholder.getOverride(this.id);
        this.override = !override.isEmpty();
        override.forEach((field, value) -> GenericAccessor.setField((Object)this, (String)field, (Object)value));
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }
}

