/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.entities;

import eu.dnetlib.uoamonitorservice.dto.TopicFull;
import eu.dnetlib.uoamonitorservice.generics.Common;
import eu.dnetlib.uoamonitorservice.generics.TopicGeneric;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Topic
extends TopicGeneric<String> {
    public Topic() {
    }

    public Topic(Topic topic) {
        super((TopicGeneric)topic);
    }

    public Topic(TopicFull topic) {
        super((TopicGeneric)topic);
        this.categories = topic.getCategories().stream().map(Common::getId).collect(Collectors.toList());
        this.categories.removeIf(Objects::isNull);
    }

    public Topic(TopicFull topic, List<String> categories) {
        super((TopicGeneric)topic);
        this.categories = new ArrayList<String>(categories);
    }

    public Topic copy() {
        Topic topic = new Topic(this);
        topic.setDefaultId(this.getId());
        topic.setId(null);
        return topic;
    }

    public Topic override(Topic topic, Topic old) {
        return (Topic)super.override((Common)topic, (Common)old);
    }

    public void addCategory(String id) {
        this.categories.add(id);
    }

    public void removeCategory(String id) {
        this.categories.remove(id);
    }
}

