/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.entities;

import eu.dnetlib.uoamonitorservice.dto.StakeholderFull;
import eu.dnetlib.uoamonitorservice.generics.StakeholderGeneric;
import eu.dnetlib.uoamonitorservice.handlers.BadRequestException;
import eu.dnetlib.uoamonitorservice.service.StakeholderService;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Stakeholder
extends StakeholderGeneric<String, String> {
    public Stakeholder() {
    }

    public Stakeholder(Stakeholder stakeholder) {
        super((StakeholderGeneric)stakeholder);
    }

    public Stakeholder(StakeholderFull stakeholder, StakeholderService service) {
        super((StakeholderGeneric)stakeholder);
        Stakeholder old = service.findByPath(stakeholder.getId());
        this.defaultId = old.getDefaultId();
        this.standalone = old.isStandalone();
        this.topics = old.getTopics();
        this.umbrella = old.getUmbrella();
    }

    public void addTopic(String id) {
        this.topics.add(id);
    }

    public void removeTopic(String id) {
        this.topics.remove(id);
    }

    public Stakeholder validate() {
        if (this.getIndex_id() == null || this.getIndex_id().isEmpty()) {
            throw new BadRequestException("index_id cannot be null or empty");
        }
        if (this.getIndex_name() == null || this.getIndex_name().isEmpty()) {
            throw new BadRequestException("index_name cannot be null or empty");
        }
        return this;
    }
}

