/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.entities;

import eu.dnetlib.uoamonitorservice.dto.SectionFull;
import eu.dnetlib.uoamonitorservice.generics.Common;
import eu.dnetlib.uoamonitorservice.generics.SectionGeneric;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Section
extends SectionGeneric<String> {
    public Section() {
    }

    public Section(Section section) {
        super((SectionGeneric)section);
    }

    public Section(SectionFull section) {
        super((SectionGeneric)section);
        this.indicators = section.getIndicators().stream().map(Common::getId).collect(Collectors.toList());
        this.indicators.removeIf(Objects::isNull);
    }

    public Section copy() {
        Section section = new Section(this);
        section.setDefaultId(this.getId());
        section.setId(null);
        return section;
    }

    public Section override(Section section, Section old) {
        section = (Section)super.override((Common)section, (Common)old);
        if (this.getTitle() != null && !this.getTitle().equals(section.getTitle()) && (old.getTitle() == null || old.getTitle().equals(section.getTitle()))) {
            section.setTitle(this.getTitle());
        }
        return section;
    }

    public void addIndicator(String id) {
        this.indicators.add(id);
    }

    public void removeIndicator(String id) {
        this.indicators.remove(id);
    }
}

