/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.entities;

import eu.dnetlib.uoamonitorservice.generics.Common;
import eu.dnetlib.uoamonitorservice.primitives.IndicatorPath;
import eu.dnetlib.uoamonitorservice.primitives.IndicatorSize;
import eu.dnetlib.uoamonitorservice.primitives.IndicatorType;
import java.util.List;

public class Indicator
extends Common {
    private String additionalDescription;
    private IndicatorType type;
    private IndicatorSize width;
    private IndicatorSize height = IndicatorSize.MEDIUM;
    private List<String> tags;
    private List<IndicatorPath> indicatorPaths;

    public Indicator() {
    }

    public Indicator(Indicator indicator) {
        super((Common)indicator);
        this.additionalDescription = indicator.getAdditionalDescription();
        this.indicatorPaths = indicator.getIndicatorPaths();
        this.tags = indicator.getTags();
        this.setType(indicator.getType());
        this.width = indicator.getWidth();
        this.height = indicator.getHeight();
    }

    public Indicator copy() {
        Indicator indicator = new Indicator(this);
        indicator.setDefaultId(this.getId());
        indicator.setId(null);
        return indicator;
    }

    public Indicator override(Indicator indicator, Indicator old) {
        indicator = (Indicator)super.override((Common)indicator, (Common)old);
        if (this.getAdditionalDescription() != null && !this.getAdditionalDescription().equals(indicator.getAdditionalDescription()) && (old.getAdditionalDescription() == null || old.getAdditionalDescription().equals(indicator.getAdditionalDescription()))) {
            indicator.setAdditionalDescription(this.getAdditionalDescription());
        }
        if (this.getWidth() != null && !this.getWidth().equals((Object)indicator.getWidth()) && (old.getWidth() == null || old.getWidth().equals((Object)indicator.getWidth()))) {
            indicator.setWidth(this.getWidth());
        }
        if (this.getHeight() != null && !this.getHeight().equals((Object)indicator.getHeight()) && (old.getHeight() == null || old.getHeight().equals((Object)indicator.getHeight()))) {
            indicator.setHeight(this.getHeight());
        }
        indicator.setIndicatorPaths(this.getIndicatorPaths());
        return indicator;
    }

    public String getAdditionalDescription() {
        return this.additionalDescription;
    }

    public void setAdditionalDescription(String description) {
        this.additionalDescription = description;
    }

    public String getType() {
        if (this.type == null) {
            return null;
        }
        return this.type.name();
    }

    public void setType(String type) {
        this.type = type == null ? null : IndicatorType.valueOf((String)type);
    }

    public IndicatorSize getWidth() {
        return this.width;
    }

    public void setWidth(IndicatorSize width) {
        this.width = width;
    }

    public IndicatorSize getHeight() {
        return this.height;
    }

    public void setHeight(IndicatorSize height) {
        this.height = height;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<IndicatorPath> getIndicatorPaths() {
        return this.indicatorPaths;
    }

    public void setIndicatorPaths(List<IndicatorPath> indicatorPaths) {
        this.indicatorPaths = indicatorPaths;
    }
}

