/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.dao;

import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.primitives.StakeholderType;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

@Repository
public interface StakeholderDAO
extends MongoRepository<Stakeholder, String> {
    public List<Stakeholder> findByDefaultId(String var1);

    public List<Stakeholder> findByType(StakeholderType var1);

    public List<Stakeholder> findByTypeAndDefaultId(StakeholderType var1, String var2);

    default public List<Stakeholder> allStakeholders() {
        return this.allStakeholders(null);
    }

    default public List<Stakeholder> allStakeholders(StakeholderType type) {
        return this.allStakeholders(type, null);
    }

    default public List<Stakeholder> allStakeholders(StakeholderType type, String id) {
        if (type != null && id != null) {
            return this.findByTypeAndDefaultId(type, id);
        }
        if (id != null) {
            return this.findByDefaultId(id);
        }
        if (type != null) {
            return this.findByType(type);
        }
        return this.findAll();
    }

    public List<Stakeholder> findByDefaultIdIsNull();

    public List<Stakeholder> findByDefaultIdIsNullAndType(StakeholderType var1);

    default public List<Stakeholder> defaultStakeholders(StakeholderType type) {
        if (type == null) {
            return this.findByDefaultIdIsNull();
        }
        return this.findByDefaultIdIsNullAndType(type);
    }

    public List<Stakeholder> findByDefaultIdIsNotNullAndStandaloneIsTrueAndUmbrellaIsNull();

    public List<Stakeholder> findByStandaloneIsTrueAndUmbrellaIsNullAndDefaultId(String var1);

    public List<Stakeholder> findByDefaultIdIsNotNullAndStandaloneIsTrueAndUmbrellaIsNullAndType(StakeholderType var1);

    public List<Stakeholder> findByStandaloneIsTrueAndUmbrellaIsNullAndTypeAndDefaultId(StakeholderType var1, String var2);

    default public List<Stakeholder> standaloneStakeholders() {
        return this.standaloneStakeholders(null);
    }

    default public List<Stakeholder> standaloneStakeholders(StakeholderType type) {
        return this.standaloneStakeholders(type, null);
    }

    default public List<Stakeholder> standaloneStakeholders(StakeholderType type, String id) {
        if (type != null && id != null) {
            return this.findByStandaloneIsTrueAndUmbrellaIsNullAndTypeAndDefaultId(type, id);
        }
        if (id != null) {
            return this.findByStandaloneIsTrueAndUmbrellaIsNullAndDefaultId(id);
        }
        if (type != null) {
            return this.findByDefaultIdIsNotNullAndStandaloneIsTrueAndUmbrellaIsNullAndType(type);
        }
        return this.findByDefaultIdIsNotNullAndStandaloneIsTrueAndUmbrellaIsNull();
    }

    public List<Stakeholder> findByDefaultIdIsNotNullAndStandaloneIsFalse();

    public List<Stakeholder> findByStandaloneIsFalseAndDefaultId(String var1);

    public List<Stakeholder> findByDefaultIdIsNotNullAndStandaloneIsFalseAndType(StakeholderType var1);

    public List<Stakeholder> findByStandaloneIsFalseAndTypeAndDefaultId(StakeholderType var1, String var2);

    default public List<Stakeholder> dependentStakeholders() {
        return this.dependentStakeholders(null);
    }

    default public List<Stakeholder> dependentStakeholders(StakeholderType type) {
        return this.dependentStakeholders(type, null);
    }

    default public List<Stakeholder> dependentStakeholders(StakeholderType type, String id) {
        if (type != null && id != null) {
            return this.findByStandaloneIsFalseAndTypeAndDefaultId(type, id);
        }
        if (id != null) {
            return this.findByStandaloneIsFalseAndDefaultId(id);
        }
        if (type != null) {
            return this.findByDefaultIdIsNotNullAndStandaloneIsFalseAndType(type);
        }
        return this.findByDefaultIdIsNotNullAndStandaloneIsFalse();
    }

    public List<Stakeholder> findByUmbrellaNotNull();

    public List<Stakeholder> findByUmbrellaNotNullAndDefaultId(String var1);

    public List<Stakeholder> findByUmbrellaNotNullAndType(StakeholderType var1);

    public List<Stakeholder> findByUmbrellaNotNullAndTypeAndDefaultId(StakeholderType var1, String var2);

    default public List<Stakeholder> umbrellaStakeholders() {
        return this.umbrellaStakeholders(null);
    }

    default public List<Stakeholder> umbrellaStakeholders(StakeholderType type) {
        return this.umbrellaStakeholders(type, null);
    }

    default public List<Stakeholder> umbrellaStakeholders(StakeholderType type, String id) {
        if (type != null && id != null) {
            return this.findByUmbrellaNotNullAndTypeAndDefaultId(type, id);
        }
        if (id != null) {
            return this.findByUmbrellaNotNullAndDefaultId(id);
        }
        if (type != null) {
            return this.findByUmbrellaNotNullAndType(type);
        }
        return this.findByUmbrellaNotNull();
    }

    public List<Stakeholder> findByDefaultIdNotNullAndStandaloneIsTrue();

    public List<Stakeholder> findByStandaloneIsTrueAndDefaultId(String var1);

    public List<Stakeholder> findByDefaultIdNotNullAndStandaloneIsTrueAndType(StakeholderType var1);

    public List<Stakeholder> findByStandaloneIsTrueAndTypeAndDefaultId(StakeholderType var1, String var2);

    default public List<Stakeholder> browseStakeholders() {
        return this.browseStakeholders(null);
    }

    default public List<Stakeholder> browseStakeholders(StakeholderType type) {
        return this.browseStakeholders(type, null);
    }

    default public List<Stakeholder> browseStakeholders(StakeholderType type, String id) {
        if (type != null && id != null) {
            return this.findByStandaloneIsTrueAndTypeAndDefaultId(type, id);
        }
        if (id != null) {
            return this.findByStandaloneIsTrueAndDefaultId(id);
        }
        if (type != null) {
            return this.findByDefaultIdNotNullAndStandaloneIsTrueAndType(type);
        }
        return this.findByDefaultIdNotNullAndStandaloneIsTrue();
    }

    public List<Stakeholder> findByDefaultIdAndCopyIsTrue(String var1);

    public Optional<Stakeholder> findByAlias(String var1);

    public <T> List<Stakeholder> findByTopicsContaining(List<T> var1);

    default public List<Stakeholder> findByTopic(String topic) {
        return this.findByTopicsContaining(Collections.singletonList(topic));
    }
}

