/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoamonitorservice.dto.TopicFull;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.primitives.Visibility;
import eu.dnetlib.uoamonitorservice.service.StakeholderService;
import eu.dnetlib.uoamonitorservice.service.TopicService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TopicController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final TopicService topicService;
    private final StakeholderService stakeholderService;

    @Autowired
    public TopicController(TopicService topicService, StakeholderService stakeholderService) {
        this.topicService = topicService;
        this.stakeholderService = stakeholderService;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/save"}, method={RequestMethod.POST})
    public ResponseEntity<TopicFull> saveTopic(@PathVariable(value="stakeholderId") String stakeholderId, @RequestBody TopicFull topicFull) {
        this.log.debug("save topic");
        this.log.debug("Alias: " + topicFull.getAlias() + " - Id: " + topicFull.getId() + " - Stakeholder: " + stakeholderId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        if (topicFull.getId() != null) {
            this.topicService.findByPath(stakeholder, topicFull.getId());
        }
        return ResponseEntity.ok((Object)this.topicService.save(stakeholder, new Topic(topicFull)));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/delete"}, method={RequestMethod.DELETE})
    public ResponseEntity<Boolean> deleteTopic(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @RequestParam(required=false, name="children") String children) {
        this.log.debug("delete topic");
        this.log.debug("Id: " + topicId + " - Stakeholder: " + stakeholderId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        this.topicService.delete(stakeholder.getType(), topic, true);
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/reorder"}, method={RequestMethod.POST})
    public ResponseEntity<List<TopicFull>> reorderTopics(@PathVariable(value="stakeholderId") String stakeholderId, @RequestBody List<String> topics) {
        this.log.debug("reorder topics");
        this.log.debug("Stakeholder: " + stakeholderId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        return ResponseEntity.ok((Object)this.stakeholderService.reorderTopics(stakeholder, topics).getTopics());
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/change-visibility"}, method={RequestMethod.POST})
    public ResponseEntity<TopicFull> changeTopicVisibility(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @RequestParam(value="visibility") Visibility visibility, @RequestParam(defaultValue="false", name="propagate") Boolean propagate) {
        this.log.debug("change topic visibility: " + visibility + " - toggle propagate: " + propagate);
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(this.stakeholderService, stakeholderId, topicId);
        return ResponseEntity.ok((Object)this.topicService.changeVisibility(stakeholder, topic, visibility, propagate));
    }
}

