/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoamonitorservice.dto.SubCategoryFull;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.SubCategory;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.primitives.Visibility;
import eu.dnetlib.uoamonitorservice.service.CategoryService;
import eu.dnetlib.uoamonitorservice.service.StakeholderService;
import eu.dnetlib.uoamonitorservice.service.SubCategoryService;
import eu.dnetlib.uoamonitorservice.service.TopicService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SubCategoryController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final StakeholderService stakeholderService;
    private final TopicService topicService;
    private final CategoryService categoryService;
    private final SubCategoryService subCategoryService;

    @Autowired
    public SubCategoryController(StakeholderService stakeholderService, TopicService topicService, CategoryService categoryService, SubCategoryService subCategoryService) {
        this.stakeholderService = stakeholderService;
        this.topicService = topicService;
        this.categoryService = categoryService;
        this.subCategoryService = subCategoryService;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/save"}, method={RequestMethod.POST})
    public ResponseEntity<SubCategoryFull> saveSubCategory(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @RequestBody SubCategoryFull subcategoryFull) {
        this.log.debug("save subcategory");
        this.log.debug("Alias: " + subcategoryFull.getAlias() + " - Id: " + subcategoryFull.getId() + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = this.categoryService.findByPath(topic, categoryId);
        if (subcategoryFull.getId() != null) {
            this.subCategoryService.findByPath(category, subcategoryFull.getId());
        }
        return ResponseEntity.ok((Object)this.subCategoryService.save(stakeholder, category, new SubCategory(subcategoryFull)));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/delete"}, method={RequestMethod.DELETE})
    public ResponseEntity<Boolean> deleteSubCategory(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @RequestParam(required=false, name="children") String children) {
        this.log.debug("delete subcategory");
        this.log.debug("Id: " + subcategoryId + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = this.categoryService.findByPath(topic, categoryId);
        SubCategory subCategory = this.subCategoryService.findByPath(category, subcategoryId);
        this.subCategoryService.delete(stakeholder.getType(), subCategory, true);
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/reorder"}, method={RequestMethod.POST})
    public ResponseEntity<List<SubCategoryFull>> reorderSubCategories(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @RequestBody List<String> subCategories) {
        this.log.debug("reorder subCategories");
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = this.categoryService.findByPath(topic, categoryId);
        return ResponseEntity.ok((Object)this.categoryService.reorderSubCategories(stakeholder, category, subCategories).getSubCategories());
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/change-visibility"}, method={RequestMethod.POST})
    public ResponseEntity<SubCategoryFull> changeSubCategoryVisibility(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @RequestParam(value="visibility") Visibility visibility, @RequestParam(defaultValue="false", name="propagate") Boolean propagate) {
        this.log.debug("change subCategory visibility: " + visibility + " - toggle propagate: " + propagate);
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(this.stakeholderService, stakeholderId, topicId);
        Category category = this.categoryService.findByPath(topic, categoryId);
        SubCategory subCategory = this.subCategoryService.findByPath(category, subcategoryId);
        return ResponseEntity.ok((Object)this.subCategoryService.changeVisibility(stakeholder, subCategory, visibility, propagate));
    }
}

