/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoamonitorservice.dto.SectionFull;
import eu.dnetlib.uoamonitorservice.dto.StakeholderFull;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Indicator;
import eu.dnetlib.uoamonitorservice.entities.Section;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.SubCategory;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.primitives.Visibility;
import eu.dnetlib.uoamonitorservice.service.CategoryService;
import eu.dnetlib.uoamonitorservice.service.IndicatorService;
import eu.dnetlib.uoamonitorservice.service.SectionService;
import eu.dnetlib.uoamonitorservice.service.StakeholderService;
import eu.dnetlib.uoamonitorservice.service.SubCategoryService;
import eu.dnetlib.uoamonitorservice.service.TopicService;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IndicatorController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final StakeholderService stakeholderService;
    private final TopicService topicService;
    private final CategoryService categoryService;
    private final SubCategoryService subCategoryService;
    private final SectionService sectionService;
    private final IndicatorService indicatorService;

    @Autowired
    public IndicatorController(StakeholderService stakeholderService, TopicService topicService, CategoryService categoryService, SubCategoryService subCategoryService, SectionService sectionService, IndicatorService indicatorService) {
        this.stakeholderService = stakeholderService;
        this.topicService = topicService;
        this.categoryService = categoryService;
        this.subCategoryService = subCategoryService;
        this.sectionService = sectionService;
        this.indicatorService = indicatorService;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/save-bulk"}, method={RequestMethod.POST})
    public ResponseEntity<StakeholderFull> saveBulkIndicators(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @RequestBody List<SectionFull> sections) throws UnsupportedEncodingException {
        this.log.debug("save bulk indicators");
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = this.categoryService.findByPath(topic, categoryId);
        SubCategory subCategory = this.subCategoryService.findByPath(category, subcategoryId);
        this.sectionService.saveBulk(stakeholder, subCategory, sections);
        return ResponseEntity.ok((Object)this.stakeholderService.getFullStakeholder(stakeholder));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/save"}, method={RequestMethod.POST})
    public ResponseEntity<Indicator> saveIndicator(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @RequestBody Indicator indicator) {
        this.log.debug("save indicator");
        this.log.debug("Name: " + indicator.getName() + " - Id: " + indicator.getId() + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId + " - Section: " + sectionId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = this.categoryService.findByPath(topic, categoryId);
        SubCategory subCategory = this.subCategoryService.findByPath(category, subcategoryId);
        Section section = this.sectionService.findByPath(subCategory, sectionId);
        if (indicator.getId() != null) {
            this.indicatorService.findByPath(section, indicator.getId());
        }
        return ResponseEntity.ok((Object)this.indicatorService.save(stakeholder, section, indicator));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/{indicatorId}/delete"}, method={RequestMethod.DELETE})
    public ResponseEntity<Boolean> deleteIndicator(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @PathVariable(value="indicatorId") String indicatorId, @RequestParam(required=false, name="children") String children) {
        this.log.debug("delete indicator");
        this.log.debug("Id: " + indicatorId + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId + " - Section: " + sectionId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = this.categoryService.findByPath(topic, categoryId);
        SubCategory subCategory = this.subCategoryService.findByPath(category, subcategoryId);
        Section section = this.sectionService.findByPath(subCategory, sectionId);
        Indicator indicator = this.indicatorService.findByPath(section, indicatorId);
        this.indicatorService.delete(stakeholder.getType(), indicator, true);
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/reorder"}, method={RequestMethod.POST})
    public ResponseEntity<List<Indicator>> reorderIndicators(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @RequestBody List<String> indicators) {
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId + " - Section: " + sectionId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = this.categoryService.findByPath(topic, categoryId);
        SubCategory subCategory = this.subCategoryService.findByPath(category, subcategoryId);
        Section section = this.sectionService.findByPath(subCategory, sectionId);
        return ResponseEntity.ok((Object)this.sectionService.reorderIndicators(stakeholder, section, indicators).getIndicators());
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/{indicatorId}/change-visibility"}, method={RequestMethod.POST})
    public ResponseEntity<Indicator> changeIndicatorVisibility(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @PathVariable(value="indicatorId") String indicatorId, @RequestParam(value="visibility") Visibility visibility) {
        this.log.debug("change indicator visibility: " + visibility);
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId + " - Section: " + sectionId + " - Indicator: " + indicatorId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(this.stakeholderService, stakeholderId, topicId);
        Category category = this.categoryService.findByPath(topic, categoryId);
        SubCategory subCategory = this.subCategoryService.findByPath(category, subcategoryId);
        Section section = this.sectionService.findByPath(subCategory, sectionId);
        Indicator indicator = this.indicatorService.findByPath(section, indicatorId);
        return ResponseEntity.ok((Object)this.indicatorService.changeVisibility(stakeholder, indicator, visibility));
    }
}

