/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.services;

import eu.dnetlib.authentication.utils.PropertyReader;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.stereotype.Component;

@Component(value="SecurityService")
public class SecurityService {
    private final Set<String> scopes;

    @Autowired
    public SecurityService(PropertyReader reader) {
        this.scopes = reader.getScopes();
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public boolean hasRefreshToken() {
        return this.scopes.contains("offline_access");
    }

    public OAuth2AuthenticationToken getToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof OAuth2AuthenticationToken) {
            return (OAuth2AuthenticationToken)authentication;
        }
        return null;
    }
}

