/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.entities;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;

public class User {
    private String sub;
    private String name;
    private String given_name;
    private String family_name;
    private String email;
    private String orcid;
    private Set<String> roles;
    private String accessToken;
    private String refreshToken;

    public User(DefaultOidcUser principal, Collection<? extends GrantedAuthority> authorities, String accessToken, String refreshToken) {
        OidcUserInfo userInfo = principal.getUserInfo();
        this.sub = userInfo.getSubject();
        this.name = userInfo.getFullName();
        this.given_name = userInfo.getGivenName();
        this.family_name = userInfo.getFamilyName();
        this.email = userInfo.getEmail();
        this.orcid = (String)userInfo.getClaim("orcid");
        this.roles = authorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGiven_name() {
        return this.given_name;
    }

    public void setGiven_name(String given_name) {
        this.given_name = given_name;
    }

    public String getFamily_name() {
        return this.family_name;
    }

    public void setFamily_name(String family_name) {
        this.family_name = family_name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getOrcid() {
        return this.orcid;
    }

    public void setOrcid(String orcid) {
        this.orcid = orcid;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }
}

