/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.security.oidc;

import eu.dnetlib.authentication.configuration.Properties;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
public class OpenAIRELogoutSuccessHandler
implements LogoutSuccessHandler {
    private final Properties properties;

    @Autowired
    public OpenAIRELogoutSuccessHandler(Properties properties) {
        this.properties = properties;
    }

    private String encodeValue(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        if (this.properties.getOidc().getRedirect() == null) {
            HttpSession session = request.getSession();
            String redirect = (String)session.getAttribute("redirect");
            session.removeAttribute("redirect");
            if (redirect == null) {
                redirect = this.properties.getRedirect();
            }
            session.invalidate();
            response.sendRedirect(this.properties.getOidc().getLogout() + this.encodeValue(redirect));
        } else {
            StringBuilder sb = new StringBuilder(this.properties.getOidc().getIssuer());
            if (this.properties.getKeycloak().booleanValue()) {
                sb.append("/protocol/openid-connect/logout");
                sb.append("?client_id=").append(this.properties.getOidc().getId());
                sb.append("&post_logout_redirect_uri=").append(this.encodeValue(this.properties.getOidc().getRedirect()));
            } else {
                sb.append("saml/logout");
            }
            response.sendRedirect(sb.toString());
        }
    }
}

