/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.security.oidc;

import com.google.gson.JsonArray;
import com.nimbusds.jwt.JWT;
import eu.dnetlib.authentication.configuration.Properties;
import eu.dnetlib.authentication.utils.AuthoritiesMapper;
import java.util.Collection;
import org.mitre.openid.connect.client.OIDCAuthoritiesMapper;
import org.mitre.openid.connect.model.UserInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class OpenAIREAuthoritiesMapper
implements OIDCAuthoritiesMapper {
    private final Properties properties;

    @Autowired
    OpenAIREAuthoritiesMapper(Properties properties) {
        this.properties = properties;
    }

    public Collection<? extends GrantedAuthority> mapAuthorities(JWT jwtToken, UserInfo userInfo) {
        JsonArray entitlements = userInfo.getSource().getAsJsonArray(this.properties.getAuthoritiesMapper());
        return AuthoritiesMapper.map(entitlements);
    }
}

