/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.security.initiliazers;

import eu.dnetlib.authentication.configuration.Properties;
import java.util.HashMap;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.client.service.impl.StaticClientConfigurationService;
import org.mitre.openid.connect.client.service.impl.StaticServerConfigurationService;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class Services {
    private final Properties properties;
    private final ServerConfiguration serverConfiguration;
    private final RegisteredClient clientConfiguration;

    @Autowired
    public Services(Properties properties, ServerConfiguration serverConfiguration, RegisteredClient clientConfiguration) {
        this.properties = properties;
        this.serverConfiguration = serverConfiguration;
        this.clientConfiguration = clientConfiguration;
    }

    @Bean
    public StaticServerConfigurationService serverConfigurationService() {
        StaticServerConfigurationService configurationService = new StaticServerConfigurationService();
        HashMap<String, ServerConfiguration> servers = new HashMap<String, ServerConfiguration>();
        servers.put(this.properties.getOidc().getIssuer(), this.serverConfiguration);
        configurationService.setServers(servers);
        return configurationService;
    }

    @Bean
    public StaticClientConfigurationService clientConfigurationService() {
        StaticClientConfigurationService configurationService = new StaticClientConfigurationService();
        HashMap<String, RegisteredClient> clients = new HashMap<String, RegisteredClient>();
        clients.put(this.properties.getOidc().getIssuer(), this.clientConfiguration);
        configurationService.setClients(clients);
        return configurationService;
    }
}

