/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.security.oidc;

import eu.dnetlib.authentication.configuration.Properties;
import eu.dnetlib.authentication.security.oidc.OpenAIREAuthenticationSuccessHandler;
import eu.dnetlib.authentication.utils.Redirect;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mitre.openid.connect.client.OIDCAuthenticationFilter;

public class OpenAIREAuthenticationFilter
extends OIDCAuthenticationFilter {
    private static final Logger logger = LogManager.getLogger(OpenAIREAuthenticationSuccessHandler.class);
    private final Properties properties;

    public OpenAIREAuthenticationFilter(Properties properties) {
        this.properties = properties;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequestWrapper wrapped = new HttpServletRequestWrapper((HttpServletRequest)req){

            public StringBuffer getRequestURL() {
                StringBuffer originalUrl = ((HttpServletRequest)this.getRequest()).getRequestURL();
                if (originalUrl.toString().contains("/openid_connect_login")) {
                    return new StringBuffer(OpenAIREAuthenticationFilter.this.properties.getOidc().getHome());
                }
                return new StringBuffer(OpenAIREAuthenticationFilter.this.properties.getOidc().getRedirect());
            }
        };
        super.doFilter((ServletRequest)wrapped, res, chain);
    }

    protected void handleAuthorizationRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Redirect.setRedirect(request, this.properties);
        super.handleAuthorizationRequest(request, response);
    }
}

