/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.user.login.utils;

import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.session.ExpiringSession;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.stereotype.Service;

@Service
public class AuthoritiesUpdater
extends HttpSessionSecurityContextRepository {
    private static final Logger logger = Logger.getLogger(AuthoritiesUpdater.class);
    @Autowired
    FindByIndexNameSessionRepository sessions;

    public void update(String id, Update update) {
        if (this.sessions != null) {
            Map map = this.sessions.findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, id);
            logger.debug((Object)map.values().toArray().length);
            for (ExpiringSession session : map.values()) {
                SecurityContext securityContext;
                Authentication authentication;
                logger.debug((Object)session.getId());
                if (session.isExpired() || !((authentication = (securityContext = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT")).getAuthentication()) instanceof OIDCAuthenticationToken)) continue;
                OIDCAuthenticationToken authOIDC = (OIDCAuthenticationToken)authentication;
                Collection<? extends GrantedAuthority> authorities = update.authorities(authentication.getAuthorities());
                logger.debug(authorities);
                securityContext.setAuthentication((Authentication)new OIDCAuthenticationToken(authOIDC.getSub(), authOIDC.getIssuer(), authOIDC.getUserInfo(), authorities, authOIDC.getIdToken(), authOIDC.getAccessTokenValue(), authOIDC.getRefreshTokenValue()));
                logger.debug((Object)"Update authorities");
                session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)securityContext);
                this.sessions.save((Session)session);
            }
        }
    }

    public static interface Update {
        public Collection<? extends GrantedAuthority> authorities(Collection<? extends GrantedAuthority> var1);
    }
}

