/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.entities.Notifications;
import eu.dnetlib.uoaadmintools.services.NotificationsService;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NotificationsController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final NotificationsService notificationsService;
    private final PortalService portalService;

    @Autowired
    public NotificationsController(NotificationsService notificationsService, PortalService portalService) {
        this.notificationsService = notificationsService;
        this.portalService = portalService;
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/community/{pid}/notifications/all"}, method={RequestMethod.GET})
    public ResponseEntity<List<Notifications>> getNotifications(@PathVariable(value="pid") String pid) {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("Portal with pid: " + pid + " not found");
        }
        List notifications = this.notificationsService.getAllNotifications(portal);
        if (notifications.isEmpty()) {
            throw new NotFoundException("Notifications settings for community with pid: " + pid + " not found");
        }
        return ResponseEntity.ok((Object)notifications);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'), @AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/community/{pid}/notifications"}, method={RequestMethod.GET})
    public ResponseEntity<Notifications> getNotificationsForUser(@PathVariable(value="pid") String pid) {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("Portal with pid: " + pid + " not found");
        }
        Notifications notifications = this.notificationsService.getUserNotifications(portal);
        if (notifications == null) {
            throw new NotFoundException("Notifications settings for community with pid: " + pid + " not found for this user.");
        }
        return ResponseEntity.ok((Object)notifications);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'), @AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/community/{pid}/notifications"}, method={RequestMethod.DELETE})
    public void deleteNotification(@PathVariable(value="pid") String pid) {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("Portal with pid: " + pid + " not found");
        }
        this.notificationsService.deleteUserNotifications(portal);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'), @AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/community/{pid}/notifications"}, method={RequestMethod.POST})
    public ResponseEntity<Notifications> saveNotification(@PathVariable(value="pid") String pid, @RequestBody Notifications notifications) {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("Portal with pid: " + pid + " not found");
        }
        return ResponseEntity.ok((Object)this.notificationsService.save(portal, notifications));
    }
}

