/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.entities.Layout;
import eu.dnetlib.uoaadmintools.services.LayoutService;
import eu.dnetlib.uoaadmintools.services.MenuService;
import eu.dnetlib.uoaadmintools.services.NotificationsService;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalResponse;
import eu.dnetlib.uoaadmintoolslibrary.services.PageService;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoaadmintoolslibrary.utils.MismatchingContentException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/community"})
public class CommunityController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final LayoutService layoutService;
    private final NotificationsService notificationsService;
    private final MenuService menuService;
    @Autowired
    private PortalService portalService;
    @Autowired
    private PageService pageService;

    @Autowired
    public CommunityController(LayoutService layoutService, NotificationsService notificationsService, MenuService menuService) {
        this.layoutService = layoutService;
        this.notificationsService = notificationsService;
        this.menuService = menuService;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ResponseEntity<List<Portal>> getAllCommunities() {
        return ResponseEntity.ok((Object)this.portalService.getAllPortalsByType("community"));
    }

    @RequestMapping(value={"/full"}, method={RequestMethod.GET})
    public ResponseEntity<List<PortalResponse>> getAllCommunitiesFull() {
        return ResponseEntity.ok((Object)this.portalService.getAllPortalsFullByType("community"));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseEntity<PortalResponse> updateCommunity(@RequestBody Portal portal) {
        if (!portal.getType().equals("community")) {
            throw new MismatchingContentException("Update Community: Portal with id: " + portal.getId() + " has type: " + portal.getType() + " instead of community");
        }
        String old_pid = this.portalService.getPortalById(portal.getId()).getPid();
        PortalResponse portalResponse = this.portalService.updatePortal(portal);
        if (!old_pid.equals(portal.getPid())) {
            this.log.debug("update portal pid - old: " + old_pid + " - new: " + portal.getPid());
            this.layoutService.updatePid(old_pid, portal);
            this.notificationsService.updatePid(old_pid, portal);
            this.menuService.updatePid(old_pid, portal);
            this.pageService.updatePid(old_pid, portal);
        }
        return ResponseEntity.ok((Object)portalResponse);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseEntity<PortalResponse> insertCommunity(@RequestBody Portal portal) {
        if (!portal.getType().equals("community")) {
            throw new MismatchingContentException("Save Community: Portal with id: " + portal.getId() + " has type: " + portal.getType() + " instead of community");
        }
        return ResponseEntity.ok((Object)this.portalService.insertPortal(portal));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> deleteCommunities(@RequestBody List<String> portals) throws Exception {
        for (String id : portals) {
            Portal portal = this.portalService.getPortalById(id);
            if (!portal.getType().equals("community")) {
                throw new MismatchingContentException("Delete Community: Portal with id: " + id + " has type: " + portal.getType() + " instead of community");
            }
            String pid = this.portalService.deletePortal(id);
            this.layoutService.deleteByPid(pid);
            this.notificationsService.deleteByPid(pid);
            this.menuService.deleteMenuByPortalPid(pid);
        }
        return ResponseEntity.ok((Object)true);
    }

    @RequestMapping(value={"/layouts"}, method={RequestMethod.GET})
    public ResponseEntity<List<Layout>> getAvailableLayouts() {
        return ResponseEntity.ok((Object)this.layoutService.findAll());
    }

    @RequestMapping(value={"/{pid}/layout"}, method={RequestMethod.GET})
    public ResponseEntity<Layout> getLayoutForCommunity(@PathVariable(value="pid") String pid) {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("CommunityController - Get layout: Portal with pid: " + pid + " not found");
        }
        return ResponseEntity.ok((Object)this.layoutService.findByPid(pid));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'), @AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/{pid}/layout"}, method={RequestMethod.POST})
    public ResponseEntity<Layout> updateLayoutForCommunity(@PathVariable(value="pid") String pid, @RequestBody Layout layout) {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("CommunityController - Update layout: Portal with pid: " + pid + " not found");
        }
        layout.setPortalPid(portal.getPid());
        return ResponseEntity.ok((Object)this.layoutService.save(layout));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'))")
    @RequestMapping(value={"/{pid}/layout"}, method={RequestMethod.DELETE})
    public ResponseEntity<Boolean> deleteLayoutForCommunity(@PathVariable(value="pid") String pid) {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("CommunityController - Delete layout: Portal with pid: " + pid + " not found");
        }
        this.layoutService.deleteByPid(pid);
        return ResponseEntity.ok((Object)true);
    }
}

