/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.entities.menu.Menu;
import eu.dnetlib.uoaadmintools.entities.menu.MenuFull;
import eu.dnetlib.uoaadmintools.entities.menu.MenuItem;
import eu.dnetlib.uoaadmintools.entities.menu.MenuItemFull;
import eu.dnetlib.uoaadmintools.services.MenuService;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoaadmintoolslibrary.utils.MismatchingContentException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MenuController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final MenuService menuService;
    private final PortalService portalService;

    @Autowired
    public MenuController(MenuService menuService, PortalService portalService) {
        this.menuService = menuService;
        this.portalService = portalService;
    }

    @RequestMapping(value={"/community/{pid}/menu/root/full"}, method={RequestMethod.GET})
    public ResponseEntity<List<MenuItemFull>> getRootMenuItemsFull(@PathVariable(value="pid") String pid) {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("Portal with pid: " + pid + " not found");
        }
        return ResponseEntity.ok((Object)this.menuService.getRootMenuItemsFull(pid));
    }

    @RequestMapping(value={"/community/{pid}/menu/full"}, method={RequestMethod.GET})
    public ResponseEntity<MenuFull> getMenuFull(@PathVariable(value="pid") String pid) {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("Portal with pid: " + pid + " not found");
        }
        return ResponseEntity.ok((Object)this.menuService.getMenuFull(pid));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'),@AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/community/{pid}/menu/update"}, method={RequestMethod.POST})
    public ResponseEntity<MenuItemFull> updateMenuItem(@PathVariable String pid, @RequestBody MenuItemFull menuItemFull) {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("Portal with pid: " + pid + " not found");
        }
        if (menuItemFull.getIsFeatured().booleanValue() && menuItemFull.getItems() != null && !menuItemFull.getItems().isEmpty()) {
            throw new MismatchingContentException("updateMenuItem: MenuItem " + menuItemFull.getId() + " cannot be featured because it has " + menuItemFull.getItems().size() + " sub menu items");
        }
        if (menuItemFull.getType() == null || menuItemFull.getType().equals("internal") && menuItemFull.getRoute() == null || menuItemFull.getType().equals("external") && menuItemFull.getUrl() == null) {
            throw new MismatchingContentException("insertMenuItem: A required field is missing in menu item: type=" + menuItemFull.getType() + " - url=" + menuItemFull.getUrl() + " - route=" + menuItemFull.getRoute());
        }
        if (menuItemFull.getPortalPid() == null) {
            menuItemFull.setPortalPid(pid);
        } else if (!menuItemFull.getPortalPid().equals(pid)) {
            throw new MismatchingContentException("updateMenuItem: MenuItem has portalPid: " + menuItemFull.getPortalPid() + " instead of " + pid);
        }
        if (menuItemFull.getId() == null) {
            throw new MismatchingContentException("updateMenuItem: This MenuItem has no id.");
        }
        return ResponseEntity.ok((Object)this.menuService.updateMenu(menuItemFull, pid));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'),@AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/community/{pid}/menu/save"}, method={RequestMethod.POST})
    public ResponseEntity<MenuItemFull> insertMenuItem(@PathVariable String pid, @RequestBody MenuItem menuItem) {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("Portal with pid: " + pid + " not found");
        }
        if (menuItem.getIsFeatured().booleanValue() && menuItem.getItems() != null && !menuItem.getItems().isEmpty()) {
            throw new MismatchingContentException("updateMenuItem: MenuItem " + menuItem.getId() + " cannot be featured because it has " + menuItem.getItems().size() + " sub menu items");
        }
        if (menuItem.getType() == null || menuItem.getType().equals("internal") && menuItem.getRoute() == null || menuItem.getType().equals("external") && menuItem.getUrl() == null) {
            throw new MismatchingContentException("insertMenuItem: A required field is missing in menu item: type=" + menuItem.getType() + " - url=" + menuItem.getUrl() + " - route=" + menuItem.getRoute());
        }
        if (menuItem.getPortalPid() == null) {
            menuItem.setPortalPid(pid);
        } else if (!menuItem.getPortalPid().equals(pid)) {
            throw new MismatchingContentException("insertMenuItem: MenuItem has portalPid: " + menuItem.getPortalPid() + " instead of " + pid);
        }
        if (menuItem.getId() != null) {
            throw new MismatchingContentException("insertMenuItem: MenuItem has already an id: " + menuItem.getId());
        }
        return ResponseEntity.ok((Object)this.menuService.insertMenuItemInMenu(menuItem, pid));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'),@AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/community/{pid}/menu/delete"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> deleteMenuItem(@PathVariable String pid, @RequestBody String menuItemId) throws Exception {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("Portal with pid: " + pid + " not found");
        }
        return ResponseEntity.ok((Object)this.menuService.deleteMenuItem(menuItemId, pid));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'),@AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/community/{pid}/menu/reorder"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> reorderMenuItems(@PathVariable String pid, @RequestBody List<MenuItemFull> menuItems) throws Exception {
        Portal portal = this.portalService.getPortal(PortalType.community, pid);
        if (portal == null) {
            throw new NotFoundException("Portal with pid: " + pid + " not found");
        }
        return ResponseEntity.ok((Object)this.menuService.reorderMenuItems(menuItems, pid));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'),@AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/community/{pid}/menu/toggle"}, method={RequestMethod.POST})
    public ResponseEntity<Menu> toggleMenu(@PathVariable(value="pid") String pid, @RequestParam String status, @RequestParam(value="featured", required=false) String isFeatured) throws Exception {
        return ResponseEntity.ok((Object)this.menuService.toggleMenu(pid, status, isFeatured));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'),@AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/community/{pid}/menu/align"}, method={RequestMethod.POST})
    public ResponseEntity<Menu> alignMenu(@PathVariable(value="pid") String pid, @RequestParam String alignment) throws Exception {
        return ResponseEntity.ok((Object)this.menuService.alignMenu(pid, alignment));
    }
}

