/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.entities.curator.Curator;
import eu.dnetlib.uoaadmintools.entities.curator.CuratorResponse;
import eu.dnetlib.uoaadmintools.services.CuratorService;
import eu.dnetlib.uoaadmintoolslibrary.utils.RolesUtils;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CuratorController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final CuratorService curatorService;
    private final RolesUtils rolesUtils;

    @Autowired
    public CuratorController(CuratorService curatorService, RolesUtils rolesUtils) {
        this.curatorService = curatorService;
        this.rolesUtils = rolesUtils;
    }

    @RequestMapping(value={"/{pid}/curator"}, method={RequestMethod.GET})
    public ResponseEntity<List<CuratorResponse>> getCurators(@PathVariable String pid) {
        return ResponseEntity.ok((Object)this.curatorService.getCurators(pid));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/curator"}, method={RequestMethod.GET})
    public ResponseEntity<Curator> getCuratorById() {
        return ResponseEntity.ok((Object)this.curatorService.findById(this.getId()));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/curator"}, method={RequestMethod.POST})
    public ResponseEntity<Curator> insertCurator(@RequestBody Curator curator) {
        curator.setId(this.getId());
        return ResponseEntity.ok((Object)this.curatorService.save(curator));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/{pid}/curator"}, method={RequestMethod.DELETE})
    public void deleteCurators(@PathVariable String pid) {
        this.curatorService.deleteCurators(pid);
    }

    private String getId() {
        String aaiId = this.rolesUtils.getAaiId();
        return aaiId.substring(0, aaiId.indexOf("@"));
    }
}

