/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.request;

import eu.dnetlib.dto.request.PersonRequest;
import eu.dnetlib.exception.SyntaxErrorException;
import eu.dnetlib.mappers.Utils;
import eu.dnetlib.mappers.solr.SolrQueryMapper;
import eu.dnetlib.solr.BasicSolrQuery;
import eu.dnetlib.solr.SortParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public interface PersonRequestMapper {
    public static final Map<String, String> solrFieldMapping = SolrQueryMapper.personFieldMapping;
    public static final Map<String, String> idFieldMapping = SolrQueryMapper.personIdFieldMapping;
    public static final List<String> defaultFq = SolrQueryMapper.personDefaultFqMapping;
    public static final Map<String, String> sortFieldMapping = SolrQueryMapper.personSortMapping;

    @Mappings(value={@Mapping(target="query", expression="java( extractQuery(personRequest) )"), @Mapping(target="fq", expression="java( extractFq(personRequest) )")})
    public BasicSolrQuery toBasicSolrQuery(PersonRequest var1);

    @Mappings(value={@Mapping(target="query", expression="java( extractIdQuery(personRequest) )"), @Mapping(target="fq", expression="java( extractFq(personRequest) )")})
    public BasicSolrQuery toBasicIdSolrQuery(PersonRequest var1);

    default public String extractQuery(PersonRequest personRequest) {
        ArrayList<String> qList = new ArrayList<String>();
        if (!Utils.isNullOrEmpty((String)personRequest.getSearch())) {
            qList.add(String.format((String)solrFieldMapping.get("search"), Utils.validateAndClean((String)personRequest.getSearch())));
        } else {
            qList.add(String.format((String)solrFieldMapping.get("search"), "*:*"));
        }
        return String.join((CharSequence)" AND ", qList);
    }

    default public String extractIdQuery(PersonRequest personRequest) {
        ArrayList<String> idList = new ArrayList<String>();
        if (personRequest.getId().length > 1) {
            throw new SyntaxErrorException("Illegal multiple value parameter. Id parameter must be unique.");
        }
        idList.add(String.format((String)idFieldMapping.get("pid"), Utils.escapeAndJoin((String[])personRequest.getId(), (String)"OR")));
        return (String)idList.get(0);
    }

    default public List<String> extractFq(PersonRequest personRequest) {
        ArrayList<String> fqList = new ArrayList<String>();
        fqList.addAll(defaultFq);
        return fqList;
    }

    default public SortParam extractSort(PersonRequest personRequest) {
        SortParam sortParam = new SortParam();
        String[] sortParams = personRequest.getSortBy().split(" ");
        sortParam.getSort().put((String)sortFieldMapping.get(sortParams[0]), sortParams[1]);
        return sortParam;
    }

    default public List<SortParam> extractSortParams(PersonRequest personRequest) {
        String[] sortByPairs;
        ArrayList<SortParam> sortParamList = new ArrayList<SortParam>();
        for (String pair : sortByPairs = personRequest.getSortBy().split(",")) {
            SortParam sortParam = new SortParam();
            String[] parts = pair.trim().split("\\s+");
            String field = parts[0];
            sortParam.getSort().put((String)sortFieldMapping.get(parts[0]), parts[1]);
            sortParamList.add(sortParam);
        }
        return sortParamList;
    }
}

