/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.controllers;

import eu.dnetlib.controllers.EntityController;
import eu.dnetlib.controllers.ResearchProductController;
import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.request.ResearchProductRequest;
import eu.dnetlib.dto.request.validators.EntityFieldConstraint;
import eu.dnetlib.dto.request.validators.FacetFieldValueContraint;
import eu.dnetlib.dto.response.CustomSolrResponse;
import eu.dnetlib.services.CsvDownloadService;
import eu.dnetlib.services.HtmlDownloadService;
import eu.dnetlib.services.ResearchProductService;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.solr.client.solrj.SolrServerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/researchProducts"})
@Validated
public class ResearchProductController
extends EntityController {
    @Autowired
    ResearchProductService researchProductService;
    @Autowired
    CsvDownloadService downloadService;
    @Autowired
    HtmlDownloadService htmlDownloadService;

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public String getById(@PathVariable String id) throws SolrServerException, IOException {
        ResearchProductRequest researchProductRequest = new ResearchProductRequest();
        researchProductRequest.setId(new String[]{id});
        return this.researchProductService.getById(researchProductRequest);
    }

    @GetMapping(value={"/search"}, produces={"application/json"})
    public CustomSolrResponse search(@Valid @EntityFieldConstraint(type=EntityRequest.Type.product) ResearchProductRequest researchProductRequest) {
        return this.researchProductService.search(researchProductRequest);
    }

    @GetMapping(value={"/searchOr"}, produces={"application/json"})
    public CustomSolrResponse searchOr(@Valid @EntityFieldConstraint(type=EntityRequest.Type.product) ResearchProductRequest researchProductRequest) {
        return this.researchProductService.searchOr(researchProductRequest);
    }

    @GetMapping(path={"/facetSearch"}, produces={"application/json"})
    public CustomSolrResponse facetSearch(@Valid @EntityFieldConstraint(type=EntityRequest.Type.product) ResearchProductRequest researchProductRequest, @Valid @FacetFieldValueContraint(type=FacetRequest.Type.product) FacetRequest facetRequest) {
        return this.researchProductService.facetSearch(researchProductRequest, facetRequest, Integer.valueOf(10));
    }

    @GetMapping(path={"/defaultFacetSearch"}, produces={"application/json"})
    public CustomSolrResponse defaultFacetSearch(@Valid @EntityFieldConstraint(type=EntityRequest.Type.product) ResearchProductRequest researchProductRequest, @Valid @FacetFieldValueContraint(type=FacetRequest.Type.product) FacetRequest facetRequest) {
        return this.researchProductService.facetSearch(researchProductRequest, facetRequest, Integer.valueOf(100));
    }

    @GetMapping(path={"/fetchHtml"})
    public String fetchHtml(@Valid @EntityFieldConstraint(type=EntityRequest.Type.product) ResearchProductRequest researchProductRequest) {
        return this.htmlDownloadService.fetchHtml((EntityRequest)researchProductRequest);
    }

    @GetMapping(path={"/fetchCsv"}, produces={"application/octet-stream"})
    public void streamCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.product) ResearchProductRequest researchProductRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"research-products.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamCsv((EntityRequest)researchProductRequest, (OutputStream)outputStream, true);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @GetMapping(path={"/fetchNoTitleCsv"}, produces={"application/octet-stream"})
    public void streamNoTitleCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.product) ResearchProductRequest researchProductRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"research-products.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamCsv((EntityRequest)researchProductRequest, (OutputStream)outputStream, false);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @GetMapping(path={"/fetchSpecialCsv"}, produces={"application/octet-stream"})
    public void streamSpecialCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.product) ResearchProductRequest researchProductRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"research-products.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamSpecialCsv((EntityRequest)researchProductRequest, (OutputStream)outputStream, true);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @GetMapping(path={"/fetchSpecialNoTitleCsv"}, produces={"application/octet-stream"})
    public void streamSpecialNoTitleCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.product) ResearchProductRequest researchProductRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"research-products.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamSpecialCsv((EntityRequest)researchProductRequest, (OutputStream)outputStream, false);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @PostMapping(value={"/byDOI"}, consumes={"application/json"}, produces={"application/json"})
    public CustomSolrResponse getByDOI(@RequestBody DOIRequest doiRequest, @RequestParam @Nullable String[] country) {
        String[] doiArray = doiRequest.getDoiArray();
        ResearchProductRequest researchProductRequest = new ResearchProductRequest();
        String[] quotedDoiArray = (String[])Arrays.stream(doiArray).map(doi -> "\"" + doi + "\"").toArray(String[]::new);
        researchProductRequest.setPid(quotedDoiArray);
        if (country != null && country.length > 0) {
            researchProductRequest.setCountry(country);
        }
        return this.researchProductService.search(researchProductRequest);
    }
}

