/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.controllers;

import eu.dnetlib.controllers.EntityController;
import eu.dnetlib.dto.request.DatasourceRequest;
import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.request.validators.EntityFieldConstraint;
import eu.dnetlib.dto.request.validators.FacetFieldValueContraint;
import eu.dnetlib.dto.response.CustomSolrResponse;
import eu.dnetlib.services.CsvDownloadService;
import eu.dnetlib.services.DatasourceService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import javax.validation.Valid;
import org.apache.solr.client.solrj.SolrServerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasources"})
@Validated
public class DatasourceController
extends EntityController {
    @Autowired
    DatasourceService datasourceService;
    @Autowired
    CsvDownloadService downloadService;

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public String getById(@PathVariable String id) throws SolrServerException, IOException {
        DatasourceRequest datasourceRequest = new DatasourceRequest();
        datasourceRequest.setId(new String[]{id});
        return this.datasourceService.getById(datasourceRequest);
    }

    @GetMapping(value={"/search"}, produces={"application/json"})
    public CustomSolrResponse search(@Valid @EntityFieldConstraint(type=EntityRequest.Type.datasource) DatasourceRequest datasourceRequest) {
        return this.datasourceService.search(datasourceRequest);
    }

    @GetMapping(path={"/facetSearch"}, produces={"application/json"})
    public CustomSolrResponse facetSearch(@Valid @EntityFieldConstraint(type=EntityRequest.Type.datasource) DatasourceRequest datasourceRequest, @Valid @FacetFieldValueContraint(type=FacetRequest.Type.datasource) FacetRequest facetRequest) {
        return this.datasourceService.facetSearch(datasourceRequest, facetRequest, Integer.valueOf(10));
    }

    @GetMapping(path={"/defaultFacetSearch"}, produces={"application/json"})
    public CustomSolrResponse defaultFacetSearch(@Valid @EntityFieldConstraint(type=EntityRequest.Type.datasource) DatasourceRequest datasourceRequest, @Valid @FacetFieldValueContraint(type=FacetRequest.Type.datasource) FacetRequest facetRequest) {
        return this.datasourceService.facetSearch(datasourceRequest, facetRequest, Integer.valueOf(100));
    }

    @GetMapping(path={"/fetchCsv"}, produces={"application/octet-stream"})
    public void streamCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.datasource) DatasourceRequest datasourceRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"datasources.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamCsv((EntityRequest)datasourceRequest, (OutputStream)outputStream, true);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @GetMapping(path={"/fetchNoTitleCsv"}, produces={"application/octet-stream"})
    public void streamNoTitleCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.datasource) DatasourceRequest datasourceRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"datasources.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamCsv((EntityRequest)datasourceRequest, (OutputStream)outputStream, false);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @GetMapping(path={"/fetchSpecialCsv"}, produces={"application/octet-stream"})
    public void streamSpecialCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.datasource) DatasourceRequest datasourceRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"datasurces.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamSpecialCsv((EntityRequest)datasourceRequest, (OutputStream)outputStream, true);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @GetMapping(path={"/fetchSpecialNoTitleCsv"}, produces={"application/octet-stream"})
    public void streamSpecialNoTitleCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.datasource) DatasourceRequest datasourceRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"datasources.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamSpecialCsv((EntityRequest)datasourceRequest, (OutputStream)outputStream, false);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }
}

