/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class RequestTimingFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(RequestTimingFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        long start = System.currentTimeMillis();
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - start;
            log.info("Request served: method={}, path={}, status={}, duration={}ms", new Object[]{request.getMethod(), request.getRequestURI(), response.getStatus(), duration});
            throw throwable;
        }
        long duration = System.currentTimeMillis() - start;
        log.info("Request served: method={}, path={}, status={}, duration={}ms", new Object[]{request.getMethod(), request.getRequestURI(), response.getStatus(), duration});
    }
}

