/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dto.request.validators;

import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.request.validators.FacetFieldValueContraint;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class FacetFieldsValidator
implements ConstraintValidator<FacetFieldValueContraint, FacetRequest> {
    private static final Map<FacetRequest.Type, Set<String>> allowedFacetValues = new HashMap();
    private FacetRequest.Type type;

    public void initialize(FacetFieldValueContraint constraintAnnotation) {
        this.type = constraintAnnotation.type();
    }

    public boolean isValid(FacetRequest facetRequest, ConstraintValidatorContext context) {
        if (facetRequest == null || facetRequest.facetFields == null) {
            return true;
        }
        Set allowedFields = (Set)allowedFacetValues.get(this.type);
        if (allowedFields == null) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("You need to specify at least one facet field. Possible values are: '" + String.valueOf(allowedFacetValues.get(this.type)) + "'").addConstraintViolation();
            return false;
        }
        for (String field : facetRequest.facetFields) {
            if (allowedFields.contains(field)) continue;
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("Facet '" + field + "' is not valid facet field for entity " + String.valueOf(this.type) + ". Allowed values are: " + String.valueOf(allowedFacetValues.get(this.type))).addConstraintViolation();
            return false;
        }
        return true;
    }

    static {
        allowedFacetValues.put(FacetRequest.Type.product, Set.of("foslabel", "relfunder", "sdg", "country", "resultlanguagename", "resulthostingdatasource", "resultbestaccessright", "resulttypeid", "instancetypename", "community", "conceptname", "eoscifguidelines", "relproject", "relfundinglevel0_id", "relfundinglevel1_id", "relfundinglevel2_id", "relorganization", "haslicense", "openaccesscolor"));
        allowedFacetValues.put(FacetRequest.Type.project, Set.of("funder", "fundinglevel0_id", "fundinglevel1_id", "fundinglevel2_id", "projectoamandatepublications", "projectstartyear", "projectendyear"));
        allowedFacetValues.put(FacetRequest.Type.datasource, Set.of("eoscdatasourcetype", "datasourceodlanguages", "datasourceodcontenttypes", "datasourcecompatibilityname", "country", "collectedfromname", "datasourcejurisdiction", "datasources", "datasourcethematic", "datasourcetypename"));
        allowedFacetValues.put(FacetRequest.Type.service, Set.of("eoscdatasourcetype", "datasourceodlanguages", "datasourceodcontenttypes", "datasourcecompatibilityname", "datasourcejurisdiction", "datasources", "datasourcethematic", "datasourcetypename", "eosctype", "country", "collectedfromname"));
        allowedFacetValues.put(FacetRequest.Type.organization, Set.of("countrynojurisdiction"));
    }
}

