/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.controllers;

import eu.dnetlib.controllers.EntityController;
import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.request.ProjectRequest;
import eu.dnetlib.dto.request.validators.EntityFieldConstraint;
import eu.dnetlib.dto.request.validators.FacetFieldValueContraint;
import eu.dnetlib.dto.response.CustomSolrResponse;
import eu.dnetlib.services.CsvDownloadService;
import eu.dnetlib.services.ProjectService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.solr.client.solrj.SolrServerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projects"})
@Validated
public class ProjectController
extends EntityController {
    @Autowired
    ProjectService projectService;
    @Autowired
    CsvDownloadService downloadService;

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public String getById(@PathVariable String id) throws SolrServerException, IOException {
        ProjectRequest projectRequest = new ProjectRequest();
        projectRequest.setId(new String[]{id});
        return this.projectService.getById(projectRequest);
    }

    @GetMapping(value={"/search"}, produces={"application/json"})
    public CustomSolrResponse search(@Valid @EntityFieldConstraint(type=EntityRequest.Type.project) ProjectRequest projectRequest) {
        return this.projectService.search(projectRequest);
    }

    @GetMapping(path={"/facetSearch"}, produces={"application/json"})
    public CustomSolrResponse facetSearch(@Valid @EntityFieldConstraint(type=EntityRequest.Type.project) ProjectRequest projectRequest, @Valid @FacetFieldValueContraint(type=FacetRequest.Type.project) FacetRequest facetRequest) {
        return this.projectService.facetSearch(projectRequest, facetRequest, Integer.valueOf(10));
    }

    @GetMapping(path={"/defaultFacetSearch"}, produces={"application/json"})
    public CustomSolrResponse defaultFacetSearch(@Valid @EntityFieldConstraint(type=EntityRequest.Type.project) ProjectRequest projectRequest, @FacetFieldValueContraint(type=FacetRequest.Type.project) FacetRequest facetRequest) {
        return this.projectService.facetSearch(projectRequest, facetRequest, Integer.valueOf(100));
    }

    @GetMapping(path={"/fetchCsv"}, produces={"application/octet-stream"})
    public void streamCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.project) ProjectRequest projectRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"projects.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamCsv((EntityRequest)projectRequest, (OutputStream)outputStream, true);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @GetMapping(path={"/fetchNoTitleCsv"}, produces={"application/octet-stream"})
    public void streamNoTitleCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.project) ProjectRequest projectRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"projects.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamCsv((EntityRequest)projectRequest, (OutputStream)outputStream, false);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @GetMapping(path={"/fetchSpecialCsv"}, produces={"application/octet-stream"})
    public void streamSpecialCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.project) ProjectRequest projectRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"projects.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamSpecialCsv((EntityRequest)projectRequest, (OutputStream)outputStream, true);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @GetMapping(path={"/fetchSpecialNoTitleCsv"}, produces={"application/octet-stream"})
    public void streamSpecialNoTitleCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.project) ProjectRequest projectRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"projects.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamSpecialCsv((EntityRequest)projectRequest, (OutputStream)outputStream, false);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @Generated
    public ProjectController() {
    }
}

