/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.services;

import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.request.ProjectRequest;
import eu.dnetlib.dto.response.CustomSolrResponse;
import eu.dnetlib.exception.DocumentNotFoundException;
import eu.dnetlib.mappers.request.ProjectRequestMapper;
import eu.dnetlib.mappers.response.CustomSolrResponseMapper;
import eu.dnetlib.mappers.solr.CustomSolrParamsMapper;
import eu.dnetlib.repository.SolrRepository;
import eu.dnetlib.solr.CustomSolrParams;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectService {
    @Autowired
    SolrRepository solrRepository;
    @Autowired
    ProjectRequestMapper mapper;
    @Autowired
    CustomSolrParamsMapper customSolrParamsMapper;
    @Autowired
    CustomSolrResponseMapper customSolrResponseMapper;

    public String getById(ProjectRequest projectRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomIdSolrParams((EntityRequest)projectRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        if (queryResponse.getResults() != null && queryResponse.getResults().size() < 1 || queryResponse.getResults().isEmpty()) {
            throw new DocumentNotFoundException("Project with id: " + projectRequest.getId()[0] + " not found.");
        }
        return this.customSolrResponseMapper.toSingleEntityResponse(queryResponse).getRecord();
    }

    public CustomSolrResponse search(ProjectRequest projectRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParams((EntityRequest)projectRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)projectRequest, customSolrParams);
    }

    public CustomSolrResponse facetSearch(ProjectRequest projectRequest, FacetRequest facetRequest, Integer facetLimit) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParams((EntityRequest)projectRequest, facetRequest, facetLimit);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)projectRequest, customSolrParams);
    }

    public CustomSolrResponse internalFacetSearch(ProjectRequest projectRequest, FacetRequest facetRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParamsForBrowseAll((EntityRequest)projectRequest, facetRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        System.out.println(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)projectRequest, customSolrParams);
    }
}

