/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.solr;

import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.mappers.solr.CustomSolrParamsMapper;
import eu.dnetlib.solr.CustomSolrParams;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CustomSolrParamsMapperImpl
implements CustomSolrParamsMapper {
    public CustomSolrParams toCustomSolrParams(EntityRequest entityRequest, FacetRequest facetRequest, Integer facetlimit) {
        if (entityRequest == null && facetRequest == null && facetlimit == null) {
            return null;
        }
        CustomSolrParams customSolrParams = new CustomSolrParams();
        if (entityRequest != null) {
            if (entityRequest.getSize() != null) {
                customSolrParams.setRows(entityRequest.getSize().intValue());
            }
            customSolrParams.setCursorMark(this.mapQueryToQueryString(entityRequest.getCursorMark()));
        }
        if (facetRequest != null) {
            List list = facetRequest.getFacetFields();
            if (list != null) {
                customSolrParams.setFacetFields(new ArrayList(list));
            }
            customSolrParams.setFacet(facetRequest.isFacet());
        }
        if (facetlimit != null) {
            customSolrParams.setFacetLimit(facetlimit.intValue());
        }
        customSolrParams.setBasicSolrQuery(this.mapBasicSolrQuery(entityRequest));
        customSolrParams.setStart(entityRequest.getPage() * entityRequest.getSize());
        customSolrParams.setMincount(1);
        customSolrParams.setOffset(0);
        customSolrParams.setSort(this.mapSort(entityRequest));
        return customSolrParams;
    }

    public CustomSolrParams toCustomSolrParamsForBrowseAll(EntityRequest entityRequest, FacetRequest facetRequest) {
        if (entityRequest == null && facetRequest == null) {
            return null;
        }
        CustomSolrParams customSolrParams = new CustomSolrParams();
        if (entityRequest != null) {
            if (entityRequest.getSize() != null) {
                customSolrParams.setRows(entityRequest.getSize().intValue());
            }
            customSolrParams.setCursorMark(this.mapQueryToQueryString(entityRequest.getCursorMark()));
        }
        if (facetRequest != null) {
            List list = facetRequest.getFacetFields();
            if (list != null) {
                customSolrParams.setFacetFields(new ArrayList(list));
            }
            customSolrParams.setFacet(facetRequest.isFacet());
        }
        customSolrParams.setBasicSolrQuery(this.mapBasicSolrQuery(entityRequest));
        customSolrParams.setStart(entityRequest.getPage() * entityRequest.getSize());
        customSolrParams.setMincount(1);
        customSolrParams.setOffset(0);
        customSolrParams.setFacetLimit(-1);
        customSolrParams.setSort(this.mapSort(entityRequest));
        return customSolrParams;
    }

    public CustomSolrParams toCustomSolrParams(EntityRequest entityRequest) {
        if (entityRequest == null) {
            return null;
        }
        CustomSolrParams customSolrParams = new CustomSolrParams();
        if (entityRequest.getSize() != null) {
            customSolrParams.setRows(entityRequest.getSize().intValue());
        }
        customSolrParams.setCursorMark(this.mapQueryToQueryString(entityRequest.getCursorMark()));
        customSolrParams.setBasicSolrQuery(this.mapBasicSolrQuery(entityRequest));
        customSolrParams.setStart(entityRequest.getPage() * entityRequest.getSize());
        customSolrParams.setFacet(false);
        customSolrParams.setMincount(1);
        customSolrParams.setOffset(0);
        customSolrParams.setFacetLimit(10);
        customSolrParams.setSort(this.mapSort(entityRequest));
        return customSolrParams;
    }

    public CustomSolrParams toCustomSolrOrParams(EntityRequest entityRequest) {
        if (entityRequest == null) {
            return null;
        }
        CustomSolrParams customSolrParams = new CustomSolrParams();
        if (entityRequest.getSize() != null) {
            customSolrParams.setRows(entityRequest.getSize().intValue());
        }
        customSolrParams.setCursorMark(this.mapQueryToQueryString(entityRequest.getCursorMark()));
        customSolrParams.setBasicSolrQuery(this.mapBasicSolrOrQuery(entityRequest));
        customSolrParams.setStart(entityRequest.getPage() * entityRequest.getSize());
        customSolrParams.setFacet(false);
        customSolrParams.setMincount(1);
        customSolrParams.setOffset(0);
        customSolrParams.setFacetLimit(10);
        customSolrParams.setSort(this.mapSort(entityRequest));
        return customSolrParams;
    }

    public CustomSolrParams toCustomIdSolrParams(EntityRequest entityRequest) {
        if (entityRequest == null) {
            return null;
        }
        CustomSolrParams customSolrParams = new CustomSolrParams();
        customSolrParams.setCursorMark(this.mapQueryToQueryString(entityRequest.getCursorMark()));
        customSolrParams.setBasicSolrQuery(this.mapBasicIdSolrQuery(entityRequest));
        customSolrParams.setStart(0);
        customSolrParams.setRows(1);
        customSolrParams.setFacet(false);
        customSolrParams.setSort(this.mapSort(entityRequest));
        return customSolrParams;
    }

    public CustomSolrParams toCustomCursorSolrParams(EntityRequest entityRequest) {
        if (entityRequest == null) {
            return null;
        }
        CustomSolrParams customSolrParams = new CustomSolrParams();
        customSolrParams.setBasicSolrQuery(this.mapBasicSolrQuery(entityRequest));
        customSolrParams.setStart(0);
        customSolrParams.setRows(500);
        customSolrParams.setFacet(false);
        customSolrParams.setCursorMark(this.mapCursorMark(entityRequest));
        customSolrParams.setSort(this.mapSortForCursor(entityRequest));
        return customSolrParams;
    }
}

