/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.response;

import eu.dnetlib.dto.response.CustomSolrBody;
import eu.dnetlib.dto.response.FacetResponse;
import eu.dnetlib.mappers.solr.FacetFieldMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper(componentModel="spring")
public interface CustomSolrBodyMapper {
    public static final CustomSolrBodyMapper INSTANCE = (CustomSolrBodyMapper)Mappers.getMapper(CustomSolrBodyMapper.class);

    @Mappings(value={@Mapping(target="results", expression="java(extractResults(queryResponse))"), @Mapping(target="facetResponse", expression="java(extractFacets(queryResponse))")})
    public CustomSolrBody toCustomSolrBody(QueryResponse var1);

    default public FacetResponse extractFacets(QueryResponse response) {
        FacetResponse facetResponse = new FacetResponse();
        FacetFieldMapper facetFieldMapper = (FacetFieldMapper)Mappers.getMapper(FacetFieldMapper.class);
        List facets = response.getFacetFields();
        if (facets != null) {
            for (FacetField facet : facets) {
                ArrayList<FacetResponse.FacetFields> facetFieldsResponseList = new ArrayList<FacetResponse.FacetFields>();
                for (FacetField.Count count : facet.getValues()) {
                    facetFieldsResponseList.add(facetFieldMapper.toFacetResponse(count));
                }
                facetResponse.getFacets().put(facet.getName(), facetFieldsResponseList);
            }
        }
        return facetResponse;
    }

    default public List<String> extractResults(QueryResponse response) {
        SolrDocumentList docs = response.getResults();
        return docs.stream().map(doc -> (String)doc.get((Object)"__json")).collect(Collectors.toList());
    }
}

