/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.request;

import eu.dnetlib.dto.request.ProjectRequest;
import eu.dnetlib.exception.SyntaxErrorException;
import eu.dnetlib.mappers.Utils;
import eu.dnetlib.mappers.solr.SolrQueryMapper;
import eu.dnetlib.solr.BasicSolrQuery;
import eu.dnetlib.solr.SortParam;
import java.time.LocalDate;
import java.time.Year;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper(componentModel="spring")
public interface ProjectRequestMapper {
    public static final Map<String, String> solrFieldMapping = SolrQueryMapper.projectFieldMapping;
    public static final Map<String, String> idFieldMapping = SolrQueryMapper.projectIdRequestMapping;
    public static final List<String> defaultFq = SolrQueryMapper.projectDefaultFqMapping;
    public static final Map<String, String> sortFieldMapping = SolrQueryMapper.projectSortMapping;
    public static final ProjectRequestMapper INSTANCE = (ProjectRequestMapper)Mappers.getMapper(ProjectRequestMapper.class);

    @Mappings(value={@Mapping(target="query", expression="java( extractQuery(projectRequest))"), @Mapping(target="fq", expression="java( extractFq(projectRequest))")})
    public BasicSolrQuery toBasicSolrQuery(ProjectRequest var1);

    @Mappings(value={@Mapping(target="query", expression="java( extractIdQuery(projectRequest) )"), @Mapping(target="fq", expression="java( extractFq(projectRequest) )")})
    public BasicSolrQuery toBasicIdSolrQuery(ProjectRequest var1);

    default public String extractQuery(ProjectRequest projectRequest) {
        ArrayList<Object> qList = new ArrayList<Object>();
        if (!Utils.isNullOrEmpty((String)projectRequest.getSearch())) {
            qList.add(String.format((String)solrFieldMapping.get("search"), Utils.validateAndClean((String)projectRequest.getSearch())));
        } else {
            qList.add(String.format((String)solrFieldMapping.get("search"), "*:*"));
        }
        if (!Utils.isNullOrEmpty((String)projectRequest.getTitle())) {
            qList.add(String.format((String)solrFieldMapping.get("title"), Utils.validateAndClean((String)projectRequest.getTitle())));
        }
        if (!Utils.isNullOrEmpty((String)projectRequest.getKeywords())) {
            qList.add(String.format((String)solrFieldMapping.get("keywords"), Utils.validateAndClean((String)projectRequest.getKeywords())));
        }
        if (!Utils.isNullOrEmpty((Boolean)projectRequest.getHasFunder())) {
            if (projectRequest.getHasFunder().booleanValue()) {
                qList.add((String)solrFieldMapping.get("hasFunder"));
            } else {
                qList.add("-" + (String)solrFieldMapping.get("hasFunder"));
            }
        }
        return String.join((CharSequence)" AND ", qList);
    }

    default public String extractIdQuery(ProjectRequest projectRequest) {
        ArrayList<String> idList = new ArrayList<String>();
        if (projectRequest.getId().length > 1) {
            throw new SyntaxErrorException("Illegal multiple value parameter. Id parameter must be unique.");
        }
        idList.add(String.format((String)idFieldMapping.get("id"), Utils.escapeAndJoin((String[])projectRequest.getId(), (String)"OR")));
        return String.join((CharSequence)" OR ", idList);
    }

    default public List<String> extractFq(ProjectRequest projectRequest) {
        ArrayList<String> fqList = new ArrayList<String>();
        fqList.addAll(defaultFq);
        if (!Utils.isNullOrEmpty((String)projectRequest.getObjIdentifier())) {
            fqList.add(String.format((String)solrFieldMapping.get("objIdentifier"), Utils.validateAndClean((String)projectRequest.getObjIdentifier())));
        }
        if (!Utils.isNullOrEmpty((LocalDate)projectRequest.getFromStartDate())) {
            if (!Utils.isNullOrEmpty((String)projectRequest.getStartDateOp())) {
                if (projectRequest.getStartDateOp().equals("NOT")) {
                    fqList.add(Utils.formatSolrDateRange((String)((String)solrFieldMapping.get("notStartDate")), (LocalDate)projectRequest.getFromStartDate(), (LocalDate)projectRequest.getToStartDate()));
                } else {
                    fqList.add(Utils.formatSolrDateRange((String)((String)solrFieldMapping.get("startDate")), (LocalDate)projectRequest.getFromStartDate(), (LocalDate)projectRequest.getToStartDate()));
                }
            } else {
                fqList.add(Utils.formatSolrDateRange((String)((String)solrFieldMapping.get("startDate")), (LocalDate)projectRequest.getFromStartDate(), (LocalDate)projectRequest.getToStartDate()));
            }
        }
        if (!Utils.isNullOrEmpty((LocalDate)projectRequest.getFromEndDate())) {
            if (!Utils.isNullOrEmpty((String)projectRequest.getEndDateOp())) {
                if (projectRequest.getEndDateOp().equals("NOT")) {
                    fqList.add(Utils.formatSolrDateRange((String)((String)solrFieldMapping.get("notEndDate")), (LocalDate)projectRequest.getFromEndDate(), (LocalDate)projectRequest.getToEndDate()));
                } else {
                    fqList.add(Utils.formatSolrDateRange((String)((String)solrFieldMapping.get("endDate")), (LocalDate)projectRequest.getFromEndDate(), (LocalDate)projectRequest.getToEndDate()));
                }
            } else {
                fqList.add(Utils.formatSolrDateRange((String)((String)solrFieldMapping.get("endDate")), (LocalDate)projectRequest.getFromEndDate(), (LocalDate)projectRequest.getToEndDate()));
            }
        }
        if (!Utils.isNullOrEmpty((Year)projectRequest.getStartYear())) {
            fqList.add(String.format((String)solrFieldMapping.get("startYear"), projectRequest.getStartYear(), projectRequest.getStartYear()));
        }
        if (!Utils.isNullOrEmpty((Year)projectRequest.getEndYear())) {
            fqList.add(String.format((String)solrFieldMapping.get("endYear"), projectRequest.getEndYear(), projectRequest.getEndYear()));
        }
        if (!Utils.isNullOrEmpty((Year)projectRequest.getActiveStartYear()) && !Utils.isNullOrEmpty((Year)projectRequest.getActiveEndYear())) {
            fqList.add(Utils.formatSolrYearRange((String)((String)solrFieldMapping.get("activeYear")), (Year)projectRequest.getActiveStartYear(), (Year)projectRequest.getActiveEndYear()));
        } else if (!Utils.isNullOrEmpty((Year)projectRequest.getActiveStartYear()) && Utils.isNullOrEmpty((Year)projectRequest.getActiveEndYear()) || Utils.isNullOrEmpty((Year)projectRequest.getActiveStartYear()) && !Utils.isNullOrEmpty((Year)projectRequest.getActiveEndYear())) {
            throw new SyntaxErrorException("Active year range must contain both start and end year values.");
        }
        if (!Utils.isNullOrEmpty((Boolean)projectRequest.getProjectoamandatepublications())) {
            fqList.add(String.format((String)solrFieldMapping.get("projectoamandatepublications"), Utils.validateAndClean((Boolean)projectRequest.getProjectoamandatepublications())));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getCode())) {
            fqList.add(String.format((String)solrFieldMapping.get("code"), Utils.escapeAndJoin((String[])projectRequest.getCode(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getAcronym())) {
            fqList.add(String.format((String)solrFieldMapping.get("acronym"), Utils.escapeAndJoin((String[])projectRequest.getAcronym(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getCountry())) {
            fqList.add(String.format((String)solrFieldMapping.get("country"), Utils.escapeAndJoin((String[])projectRequest.getCountry(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getFunder())) {
            fqList.add(String.format((String)solrFieldMapping.get("funder"), Utils.escapeAndJoin((String[])projectRequest.getFunder(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getFundingShortName())) {
            fqList.add(String.format((String)solrFieldMapping.get("fundingShortName"), Utils.escapeAndJoin((String[])projectRequest.getFundingShortName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getFundingStreamId())) {
            String fundingStreamId = Utils.escapeAndJoin((String[])projectRequest.getFundingStreamId(), (String)"OR");
            fqList.add(String.format((String)solrFieldMapping.get("fundingStreamId"), fundingStreamId, fundingStreamId, fundingStreamId));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getFundinglevel0Id())) {
            fqList.add(String.format((String)solrFieldMapping.get("fundinglevel0Id"), Utils.escapeAndJoin((String[])projectRequest.getFundinglevel0Id(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getFundinglevel1Id())) {
            fqList.add(String.format((String)solrFieldMapping.get("fundinglevel1Id"), Utils.escapeAndJoin((String[])projectRequest.getFundinglevel1Id(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getFundinglevel2Id())) {
            fqList.add(String.format((String)solrFieldMapping.get("fundinglevel2Id"), Utils.escapeAndJoin((String[])projectRequest.getFundinglevel2Id(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getCallIdentifier())) {
            fqList.add(String.format((String)solrFieldMapping.get("callIdentifier"), Utils.escapeAndJoin((String[])projectRequest.getCallIdentifier(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getRelResultId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relResultId"), Utils.escapeAndJoin((String[])projectRequest.getRelResultId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getRelCommunityId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relCommunityId"), Utils.escapeAndJoin((String[])projectRequest.getRelCommunityId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getRelOrganizationCountryCode())) {
            fqList.add(String.format((String)solrFieldMapping.get("relOrganizationCountryCode"), Utils.escapeAndJoin((String[])projectRequest.getRelOrganizationCountryCode(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getRelOrganizationName())) {
            fqList.add(String.format((String)solrFieldMapping.get("relOrganizationName"), Utils.escapeAndJoin((String[])projectRequest.getRelOrganizationName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getRelOrganizationId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relOrganizationId"), Utils.escapeAndJoin((String[])projectRequest.getRelOrganizationId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])projectRequest.getRelCollectedFromDatasourceId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relCollectedFromDatasourceId"), Utils.escapeAndJoin((String[])projectRequest.getRelCollectedFromDatasourceId(), (String)"OR")));
        }
        return fqList;
    }

    default public SortParam extractSort(ProjectRequest projectRequest) {
        SortParam sortParam = new SortParam();
        String[] sortParams = projectRequest.getSortBy().split(" ");
        sortParam.getSort().put((String)sortFieldMapping.get(sortParams[0]), sortParams[1]);
        return sortParam;
    }

    default public List<SortParam> extractSortParams(ProjectRequest projectRequest) {
        String[] sortByPairs;
        ArrayList<SortParam> sortParamList = new ArrayList<SortParam>();
        for (String pair : sortByPairs = projectRequest.getSortBy().split(",")) {
            SortParam sortParam = new SortParam();
            String[] parts = pair.trim().split("\\s+");
            String field = parts[0];
            sortParam.getSort().put((String)sortFieldMapping.get(parts[0]), parts[1]);
            sortParamList.add(sortParam);
        }
        return sortParamList;
    }
}

