/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.html;

import eu.dnetlib.dhp.schema.solr.Author;
import eu.dnetlib.dhp.schema.solr.Pid;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import eu.dnetlib.helpers.html.ResearchProductHtml;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public interface ResearchProductsHtmlMapper {
    @Mappings(value={@Mapping(target="type", source="result.resulttype"), @Mapping(target="title", source="result.maintitle"), @Mapping(target="authors", expression="java(extractAuthor(solrRecord))"), @Mapping(target="publicationYear", source="result.publicationdate"), @Mapping(target="doi", expression="java(extractDoi(solrRecord))"), @Mapping(target="permanentIdentifier", expression="java(extractPermanentIdentifier(solrRecord))"), @Mapping(target="publicationType", expression="java(exctractPublicationType(solrRecord))"), @Mapping(target="journal", source="result.journal.name"), @Mapping(target="projectName_gaNumber", expression="java(extractFunder(solrRecord))"), @Mapping(target="accessMode", source="result.bestaccessright.label")})
    public ResearchProductHtml toResearchProductHtml(SolrRecord var1);

    default public String extractAuthor(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getResult().getAuthor()).stream().flatMap(Collection::stream).map(Author::getFullname).filter(Objects::nonNull).collect(Collectors.joining(";"));
    }

    default public String extractPermanentIdentifier(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getResult().getInstance()).stream().flatMap(Collection::stream).findFirst().flatMap(instance -> Optional.ofNullable(instance.getUrl()).filter(urls -> !urls.isEmpty()).map(urls -> (String)urls.get(0))).orElse("");
    }

    default public String exctractPublicationType(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getResult().getInstance()).stream().flatMap(Collection::stream).findFirst().map(instance -> instance.getInstancetype()).orElse("");
    }

    default public String extractDoi(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getPid()).stream().flatMap(Collection::stream).filter(pid -> "doi".equalsIgnoreCase(pid.getTypeLabel())).map(Pid::getValue).collect(Collectors.joining(";"));
    }

    default public String extractFunder(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getLinks()).stream().flatMap(Collection::stream).filter(relatedRecord -> "isProducedBy".equalsIgnoreCase(relatedRecord.getHeader().getRelationClass())).map(relatedRecord -> {
            Object funderString = Optional.ofNullable(relatedRecord.getFunding()).map(funding -> Optional.ofNullable(funding.getFunder()).map(funder -> Optional.ofNullable(funder.getShortname()).orElse(funder.getName())).orElse("")).orElse("");
            String projectString = Optional.ofNullable(relatedRecord.getAcronym()).orElseGet(() -> Optional.ofNullable(relatedRecord.getProjectTitle()).orElse("Unknown"));
            funderString = (String)funderString + "|" + projectString;
            String code = Optional.ofNullable(relatedRecord.getCode()).map(c -> "(" + c + ")").orElse("");
            return (String)funderString + code;
        }).collect(Collectors.joining(";"));
    }
}

