/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.loginservice.controllers;

import eu.dnetlib.loginservice.properties.Properties;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HealthController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Properties properties;

    @Autowired
    public HealthController(Properties properties) {
        this.properties = properties;
    }

    @RequestMapping(value={"", "/health_check"}, method={RequestMethod.GET})
    public String hello() {
        this.log.debug("Hello from Login service!");
        return "Hello from Login service!";
    }

    @PreAuthorize(value="hasAnyAuthority('PORTAL_ADMINISTRATOR')")
    @RequestMapping(value={"/health_check/advanced"}, method={RequestMethod.GET})
    public Map<String, String> checkEverything() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("authentication.domain", this.properties.getDomain());
        response.put("authentication.keycloak", this.properties.getKeycloak().toString());
        response.put("authentication.redis.host", this.properties.getRedis().getHost());
        response.put("authentication.oidc.issuer", this.properties.getOidc().getIssuer());
        response.put("authentication.oidc.logout", this.properties.getOidc().getLogout());
        response.put("authentication.oidc.home", this.properties.getOidc().getHome());
        response.put("authentication.oidc.scope", this.properties.getOidc().getScope());
        response.put("authentication.oidc.id", this.properties.getOidc().getId());
        response.put("authentication.oidc.secret", this.properties.getOidc().getSecret());
        response.put("authentication.session", this.properties.getSession());
        response.put("authentication.accessToken", this.properties.getAccessToken());
        response.put("authentication.redirect", this.properties.getRedirect());
        response.put("authentication.authorities-mappe", this.properties.getAuthoritiesMapper());
        return response;
    }
}

