/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.loginservice.security.initiliazers;

import eu.dnetlib.loginservice.properties.Properties;
import eu.dnetlib.loginservice.security.oidc.OpenAIREAuthoritiesMapper;
import eu.dnetlib.loginservice.utils.EntryPoint;
import eu.dnetlib.loginservice.utils.ScopeReader;
import org.mitre.openid.connect.client.OIDCAuthenticationProvider;
import org.mitre.openid.connect.client.OIDCAuthoritiesMapper;
import org.mitre.openid.connect.client.service.impl.PlainAuthRequestUrlBuilder;
import org.mitre.openid.connect.client.service.impl.StaticAuthRequestOptionsService;
import org.mitre.openid.connect.client.service.impl.StaticSingleIssuerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;

@Configuration
public class Primitives {
    private final Properties properties;
    private final OpenAIREAuthoritiesMapper authoritiesMapper;

    @Autowired
    public Primitives(Properties properties, OpenAIREAuthoritiesMapper authoritiesMapper) {
        this.properties = properties;
        this.authoritiesMapper = authoritiesMapper;
    }

    @Bean
    public ScopeReader scopeReader() {
        return new ScopeReader(this.properties.getOidc().getScope());
    }

    @Bean
    public DefaultWebSecurityExpressionHandler handler() {
        return new DefaultWebSecurityExpressionHandler();
    }

    @Bean
    public PlainAuthRequestUrlBuilder builder() {
        return new PlainAuthRequestUrlBuilder();
    }

    @Bean
    public OIDCAuthenticationProvider provider() {
        OIDCAuthenticationProvider provider = new OIDCAuthenticationProvider();
        provider.setAuthoritiesMapper((OIDCAuthoritiesMapper)this.authoritiesMapper);
        return provider;
    }

    @Bean
    public StaticSingleIssuerService issuerService() {
        StaticSingleIssuerService issuerService = new StaticSingleIssuerService();
        issuerService.setIssuer(this.properties.getOidc().getIssuer());
        return issuerService;
    }

    @Bean
    public EntryPoint entryPoint() {
        return new EntryPoint();
    }

    @Bean
    public StaticAuthRequestOptionsService optionsService() {
        return new StaticAuthRequestOptionsService();
    }
}

