package eu.dnetlib.msro.openaireplus.workflows.nodes.consistency;

import java.util.HashSet;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class FindInvalidStoresJobNode extends SimpleJobNode {

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Autowired
	private MDStoreDao mdstoreDao;

	@Autowired
	private ObjectStoreDao objDao;

	private static final Log log = LogFactory.getLog(FindInvalidStoresJobNode.class);

	private boolean deleteInvalidStores = false;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final ISLookUpService lookup = serviceLocator.getService(ISLookUpService.class);
		final ISRegistryService registry = serviceLocator.getService(ISRegistryService.class);

		final String q1 = "distinct-values("
				+ "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType')//PARAM[@category='MDSTORE_ID' or @category='OBJECTSTORE_ID'] "
				+ "return $x/text())";

		final String q2 = "for $x in collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType') return $x//RESOURCE_IDENTIFIER/@value/string()";
		final String q3 = "for $x in collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') return $x//RESOURCE_IDENTIFIER/@value/string()";

		final Set<String> valids = new HashSet<>(lookup.quickSearchProfile(q1));

		int countMdstores = 0;
		int countInvalidMdStores = 0;
		int countDeletedMdStores = 0;
		int countObjstores = 0;
		int countInvalidObjStores = 0;
		int countDeletedObjStores = 0;

		for (final String id : lookup.quickSearchProfile(q2)) {
			countMdstores++;
			if (!valids.contains(id)) {
				log.warn("Invalid mdstore: " + id);
				countInvalidMdStores++;
				if (deleteInvalidStores) {
					registry.deleteProfile(id);
					mdstoreDao.deleteMDStore(id);
					log.info(" -- Deleted");
					countDeletedMdStores++;
				}

			}
		}

		for (final String id : lookup.quickSearchProfile(q3)) {
			countObjstores++;
			if (!valids.contains(id)) {
				log.warn("Invalid objstore: " + id);
				countInvalidObjStores++;
				if (deleteInvalidStores) {
					registry.deleteProfile(id);
					objDao.deleteObjectStore(id);
					log.info(" -- Deleted");
					countDeletedObjStores++;
				}

			}
		}
		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "totalMdStores", countMdstores);
		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "invalidMdStores", countInvalidMdStores);
		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "deletedMdStores", countDeletedMdStores);
		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "totalObjStores", countObjstores);
		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "invalidObjStores", countInvalidObjStores);
		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "deletedObjStores", countDeletedObjStores);

		return Arc.DEFAULT_ARC;
	}

	public boolean isDeleteInvalidStores() {
		return deleteInvalidStores;
	}

	public void setDeleteInvalidStores(final boolean deleteInvalidStores) {
		this.deleteInvalidStores = deleteInvalidStores;
	}
}
