/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.conf;

import com.google.common.collect.Lists;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationExistReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.IdentityFunction;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

public class ISLookUpClient {
    private static final Log log = LogFactory.getLog(ISLookUpClient.class);
    @Value(value="${services.oai.publisher.db.xquery}")
    private String xpathToCurrentDB;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource
    private OAIConfigurationExistReader configuration;

    public List<MDFInfo> listMetadataFormats(boolean onlyEnabled) throws ISLookUpException, DocumentException, OaiPublisherException {
        return Lists.newArrayList(this.configuration.getMetadataFormatInfo(onlyEnabled));
    }

    @Cacheable(value={"unaryFunctions"}, key="#tdsRuleId")
    public UnaryFunction<String, String> getUnaryFunctionFromTDSRule(String tdsRuleId) {
        log.fatal((Object)("Not using cache to get TDSRule " + tdsRuleId));
        String queryCodeRule = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + tdsRuleId + "']/BODY/CONFIGURATION/SCRIPT/CODE/*[local-name()='stylesheet']";
        String xsltCode = null;
        try {
            xsltCode = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(queryCodeRule);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.fatal((Object)("Unexisting TDSRule profile with identifier " + tdsRuleId));
            throw new OaiPublisherRuntimeException(e);
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherRuntimeException(e);
        }
        if (StringUtils.isBlank((String)xsltCode)) {
            log.warn((Object)("Unexpected blank stylesheet in TDSRule profile with id: " + tdsRuleId + ". Returning identity function."));
            return new IdentityFunction();
        }
        return new ApplyXslt(xsltCode);
    }

    @Cacheable(value={"oaiDB"})
    public String getCurrentDB() throws ISLookUpDocumentNotFoundException, ISLookUpException {
        log.fatal((Object)"Not using cache to get the current OAI db");
        String currentDBName = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(this.xpathToCurrentDB);
        log.info((Object)("Current OAI DB:" + currentDBName));
        return currentDBName;
    }

    @CacheEvict(value={"unaryFunctions", "oaiDB"}, allEntries=true, beforeInvocation=true)
    public void evictCaches() {
        log.info((Object)"Evicted caches oaiDB and unaryFunctions");
    }

    public OAIConfigurationExistReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAIConfigurationExistReader configuration) {
        this.configuration = configuration;
    }
}

