/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.provision.index.rmi.IndexService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FinalizeDedupIndexJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(FinalizeDedupIndexJobNode.class);

    protected String obtainServiceId(NodeToken token) {
        return this.getServiceLocator().getServiceId(IndexService.class);
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        String indexDsId = this.getEnvParam(token, "index_id");
        log.info((Object)("preparing blackboard job DELETE_BY_QUERY index: " + indexDsId));
        String backendId = this.getBackendId(indexDsId);
        if (StringUtils.isBlank((String)backendId)) {
            throw new MSROException("empty index backend Id");
        }
        job.setAction("DELETE_BY_QUERY");
        job.getParameters().put("id", indexDsId);
        job.getParameters().put("backend_Id", backendId);
        job.getParameters().put("query", this.buildQuery(this.getEnvParam(token, "entityType"), this.getEnvParam(token, "index.feed.timestamp"), this.getEnvParam(token, "actionset")));
    }

    private String buildQuery(String entityType, String version, String actionset) {
        String query = String.format("__dsversion:{* TO %s} AND oaftype:%s AND actionset:%s", InputDocumentFactory.getParsedDateField((String)version), entityType, actionset);
        log.info((Object)("delete by query: " + query));
        return query;
    }

    private String getEnvParam(NodeToken token, String name) throws MSROException {
        String value = token.getEnv().getAttribute(name);
        if (StringUtils.isBlank((String)value)) {
            throw new MSROException(String.format("unable to finalize index feeding, cannot find property '%s' in the workflow env.", name));
        }
        return value;
    }

    public String getBackendId(String indexDsId) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        return ((ISLookUpService)this.getServiceLocator().getService(ISLookUpService.class)).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + indexDsId + "']//BACKEND/text()");
    }
}

