/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholexplorer.api.index;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.IdsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.elasticsearch.core.CountResponse;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.sx.scholix.Scholix;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixEntityId;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixRelationship;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixResource;
import eu.dnetlib.dhp.schema.sx.scholix.flat.ScholixFlat;
import eu.dnetlib.scholexplorer.api.ScholixException;
import eu.dnetlib.scholexplorer.api.TaggedCounter;
import eu.dnetlib.scholexplorer.api.index.ElasticSearchPool;
import eu.dnetlib.scholexplorer.api.index.ElasticSearchProperties;
import eu.dnetlib.scholexplorer.api.index.ScholixIndexManager;
import eu.dnetlib.scholexplorer.api.model.KPIModel;
import eu.dnetlib.scholexplorer.api.model.ScholixStatsModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScholixIndexManager {
    @Autowired
    ElasticSearchProperties elasticSearchProperties;
    @Autowired
    ElasticSearchPool connectionPool;
    final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    TaggedCounter myCounter;
    private Map<String, Long> linkProviders;
    private Map<String, Long> linkSourcePublishers;
    private Map<String, Long> linkTargetPublishers;
    private KPIModel kpiModel;

    public Map<String, Long> getLinkProviders() {
        try {
            if (this.linkProviders == null) {
                this.linkProviders = (Map)this.mapper.readValue(this.retrieveLastStats("link_providers"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            return this.linkProviders;
        }
        catch (Throwable e) {
            throw new ScholixException("Error reading link providers from file", e);
        }
    }

    public Map<String, Long> getLinkSourcePublishers() {
        try {
            if (this.linkSourcePublishers == null) {
                this.linkSourcePublishers = (Map)this.mapper.readValue(this.retrieveLastStats("link_source_publishers"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            return this.linkSourcePublishers;
        }
        catch (Throwable e) {
            throw new ScholixException("Error reading link source publishers from file", e);
        }
    }

    public Map<String, Long> getLinkTargetPublishers() {
        try {
            if (this.linkTargetPublishers == null) {
                this.linkTargetPublishers = (Map)this.mapper.readValue(this.retrieveLastStats("link_target_publishers"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            return this.linkTargetPublishers;
        }
        catch (Throwable e) {
            throw new ScholixException("Error reading link target publishers from file", e);
        }
    }

    private List<String> extractIdentifiersFromScholix(List<Hit<ScholixFlat>> scholix) {
        return scholix.stream().filter(s -> s.source() != null).flatMap(s -> Stream.of(((ScholixFlat)s.source()).getSourceId(), ((ScholixFlat)s.source()).getTargetId())).distinct().toList();
    }

    private Map<String, ScholixResource> retrieveResources(ElasticsearchClient client, List<String> ids) throws Exception {
        IdsQuery idsQuery = new IdsQuery.Builder().values(ids).build();
        Query searchQuery = (Query)new Query.Builder().ids(idsQuery).build();
        SearchResponse result = client.search(s -> s.index(this.elasticSearchProperties.getIndexResourceName(), new String[0]).query(searchQuery).size(Integer.valueOf(ids.size())), Map.class);
        return result.hits().hits().stream().map(r -> {
            try {
                return (ScholixResource)this.mapper.readValue(((Map)r.source()).get("body").toString(), ScholixResource.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toMap(ScholixResource::getDnetIdentifier, v -> v, (a, b) -> a));
    }

    private void fixUrl(ScholixResource resource) {
        if (resource.getIdentifier() != null) {
            resource.getIdentifier().forEach(pid -> {
                if ("doi".equalsIgnoreCase(pid.getSchema()) && pid.getUrl() == null) {
                    pid.setUrl("https://dx.doi.org/" + pid.getIdentifier());
                }
                if ("pmc".equalsIgnoreCase(pid.getSchema()) && pid.getUrl() == null) {
                    pid.setUrl("https://www.ncbi.nlm.nih.gov/pmc/articles/" + pid.getIdentifier());
                }
                if ("pmid".equalsIgnoreCase(pid.getSchema()) && pid.getUrl() == null) {
                    pid.setUrl("https://pubmed.ncbi.nlm.nih.gov/" + pid.getIdentifier());
                }
                if ("arxiv".equalsIgnoreCase(pid.getSchema()) && pid.getUrl() == null) {
                    pid.setUrl("https://arxiv.org/abs/" + pid.getIdentifier());
                }
                if ("handle".equalsIgnoreCase(pid.getSchema()) && pid.getUrl() == null) {
                    pid.setUrl("https://hdl.handle.net/" + pid.getIdentifier());
                }
                if ("openaireIdentifier".equalsIgnoreCase(pid.getSchema()) && pid.getUrl() == null) {
                    pid.setUrl("https://explore.openaire.eu/search/result?id=" + pid.getIdentifier().replace("50|", ""));
                }
            });
        }
    }

    private Scholix generateScholix(ScholixFlat flat, ScholixResource source, ScholixResource target) throws ScholixException {
        if (flat == null || source == null || target == null) {
            throw new ScholixException("Error generating scholix null input");
        }
        Scholix scholix = new Scholix();
        this.fixUrl(source);
        this.fixUrl(target);
        scholix.setSource(source);
        scholix.setTarget(target);
        scholix.setIdentifier(flat.getIdentifier());
        ScholixRelationship r = new ScholixRelationship();
        r.setSchema("datacite");
        r.setName(flat.getRelationType().toLowerCase());
        scholix.setRelationship(r);
        scholix.setPublicationDate(flat.getPublicationDate());
        scholix.setLinkprovider(flat.getLinkProviders().stream().map(p -> {
            ScholixEntityId eid = new ScholixEntityId();
            eid.setName(p);
            return eid;
        }).toList());
        HashMap publishers = new HashMap();
        if (source.getPublisher() != null) {
            source.getPublisher().forEach(p -> publishers.put(p.getName(), p));
        }
        if (target.getPublisher() != null) {
            target.getPublisher().forEach(p -> publishers.put(p.getName(), p));
        }
        scholix.setPublisher(publishers.values().stream().toList());
        return scholix;
    }

    private Query createFinalQuery(List<Query> queries) throws ScholixException {
        return Query.of(q -> q.bool(b -> b.must(queries)));
    }

    public List<Pair<String, Long>> totalLinksByProvider(String filterName) throws ScholixException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Scholix> findPage(String relType) throws ScholixException {
        ElasticsearchClient client = null;
        try {
            client = (ElasticsearchClient)this.connectionPool.getResource();
            Query tb = TermQuery.of(m -> m.field("relationType").value(relType).caseInsensitive(Boolean.valueOf(true)))._toQuery();
            SearchResponse scholixRes = client.search(s -> s.index(this.elasticSearchProperties.getIndexName(), new String[0]).query(tb).size(Integer.valueOf(100)), ScholixFlat.class);
            Map idMap = this.retrieveResources(client, this.extractIdentifiersFromScholix(scholixRes.hits().hits()));
            List<Scholix> list = scholixRes.hits().hits().stream().map(Hit::source).map(s -> {
                try {
                    return this.generateScholix(s, (ScholixResource)idMap.get(s.getSourceId()), (ScholixResource)idMap.get(s.getTargetId()));
                }
                catch (ScholixException e) {
                    throw new RuntimeException(e);
                }
            }).toList();
            return list;
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    this.connectionPool.returnResource((Object)client);
                }
                catch (ScholixException e) {
                    throw new ScholixException("Error returning resource to pool", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveLastStats(String statsName) {
        ElasticsearchClient client = null;
        try {
            client = (ElasticsearchClient)this.connectionPool.getResource();
            Query tb = TermQuery.of(m -> m.field("type").value(statsName))._toQuery();
            SearchResponse stats = client.search(s -> s.index(this.elasticSearchProperties.getIndexStatsName(), new String[0]).query(tb).sort(g -> g.field(f -> f.field("date").order(SortOrder.Desc))).size(Integer.valueOf(1)), ScholixStatsModel.class);
            if (stats.hits().hits().isEmpty()) {
                throw new ScholixException("No kpi stats found");
            }
            String string = ((ScholixStatsModel)((Hit)stats.hits().hits().get(0)).source()).getBody();
            return string;
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    this.connectionPool.returnResource((Object)client);
                }
                catch (ScholixException e) {
                    throw new ScholixException("Error returning resource to pool", (Throwable)e);
                }
            }
        }
        return null;
    }

    public KPIModel getKPI() throws ScholixException, JsonProcessingException {
        return (KPIModel)this.mapper.readValue(this.retrieveLastStats("kpi"), KPIModel.class);
    }

    public Map<String, Long> totalLinksPublisher(RelationPrefix prefix, String filterName) throws ScholixException {
        return this.getLinkProviders();
    }

    private void incrementPidCounter(RelationPrefix prefix, String value) {
        switch (value.toLowerCase()) {
            case "doi": {
                this.myCounter.increment(String.format("%s_doi", prefix));
                break;
            }
            case "pmc": {
                this.myCounter.increment(String.format("%s_pmc", prefix));
                break;
            }
            default: {
                this.myCounter.increment(String.format("%s_other", prefix));
            }
        }
    }

    /*
     * Loose catch block
     */
    public Pair<Long, List<Scholix>> linksFromPid(String linkProvider, String targetPid, String targetPidType, String targetPublisher, String targetType, String sourcePid, String sourcePidType, String sourcePublisher, String sourceType, String relation, String fromDate, String toDate, Long page, Integer pageSize) throws ScholixException {
        ImmutablePair immutablePair;
        ElasticsearchClient client;
        block33: {
            CountResponse ct;
            block31: {
                ImmutablePair immutablePair2;
                block32: {
                    block29: {
                        ImmutablePair immutablePair3;
                        block30: {
                            if (sourcePid == null && sourcePidType == null && sourceType == null && targetType == null && targetPid == null && targetPidType == null && sourcePublisher == null && targetPublisher == null && linkProvider == null) {
                                throw new ScholixException("One of sourcePid, targetPid, sourcePublisher, targetPublisher, linkProvider should be not null");
                            }
                            client = null;
                            if ((page + 1L) * (long)pageSize.intValue() <= 10000L) break block29;
                            immutablePair3 = new ImmutablePair((Object)0L, new ArrayList());
                            if (client == null) break block30;
                            try {
                                this.connectionPool.returnResource((Object)client);
                            }
                            catch (ScholixException e) {
                                throw new ScholixException("Error returning resource to pool", (Throwable)e);
                            }
                        }
                        return immutablePair3;
                    }
                    client = (ElasticsearchClient)this.connectionPool.getResource();
                    ArrayList<Query> queries = new ArrayList<Query>();
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{linkProvider})) {
                        this.myCounter.increment("linkProvider");
                        queries.add(MatchQuery.of(f -> f.field("linkProviders").query(linkProvider))._toQuery());
                    }
                    if (StringUtils.isNotBlank((CharSequence)targetPid)) {
                        this.myCounter.increment("targetPid");
                        queries.add(BoolQuery.of(b -> b.should(TermQuery.of(t -> t.field("targetPid").value(targetPid).caseInsensitive(Boolean.valueOf(true)))._toQuery(), new Query[]{TermQuery.of(t -> t.field("targetId").value(targetPid).caseInsensitive(Boolean.valueOf(true)))._toQuery()}))._toQuery());
                    }
                    if (StringUtils.isNotBlank((CharSequence)targetPidType)) {
                        this.incrementPidCounter(RelationPrefix.target, targetPidType);
                        queries.add(TermQuery.of(t -> t.field("targetPidType").value(targetPidType).caseInsensitive(Boolean.valueOf(true)))._toQuery());
                    }
                    if (StringUtils.isNotBlank((CharSequence)targetPublisher)) {
                        queries.add(TermQuery.of(t -> t.field("targetPublisher").value(targetPublisher).caseInsensitive(Boolean.valueOf(true)))._toQuery());
                    }
                    if (StringUtils.isNotBlank((CharSequence)targetType)) {
                        this.myCounter.increment("targetType");
                        queries.add(TermQuery.of(t -> t.field("targetType").value(targetType).caseInsensitive(Boolean.valueOf(true)))._toQuery());
                    }
                    if (StringUtils.isNotBlank((CharSequence)sourcePid)) {
                        this.myCounter.increment("sourcePid");
                        queries.add(BoolQuery.of(b -> b.should(TermQuery.of(t -> t.field("sourcePid").value(sourcePid).caseInsensitive(Boolean.valueOf(true)))._toQuery(), new Query[]{TermQuery.of(t -> t.field("sourceId").value(sourcePid).caseInsensitive(Boolean.valueOf(true)))._toQuery()}))._toQuery());
                    }
                    if (StringUtils.isNotBlank((CharSequence)sourcePidType)) {
                        this.myCounter.increment("sourcePidType");
                        queries.add(TermQuery.of(t -> t.field("sourcePidType").value(sourcePidType).caseInsensitive(Boolean.valueOf(true)))._toQuery());
                    }
                    if (StringUtils.isNotBlank((CharSequence)sourcePublisher)) {
                        queries.add(TermQuery.of(t -> t.field("sourcePublisher").value(sourcePublisher).caseInsensitive(Boolean.valueOf(true)))._toQuery());
                    }
                    if (StringUtils.isNotBlank((CharSequence)sourceType)) {
                        this.myCounter.increment("sourceType");
                        queries.add(TermQuery.of(t -> t.field("sourceType").value(sourceType).caseInsensitive(Boolean.valueOf(true)))._toQuery());
                    }
                    if (StringUtils.isNotBlank((CharSequence)relation)) {
                        this.myCounter.increment("relation");
                        queries.add(TermQuery.of(m -> m.field("relationType").value(relation).caseInsensitive(Boolean.valueOf(true)))._toQuery());
                    }
                    if (StringUtils.isNotBlank((CharSequence)fromDate)) {
                        this.myCounter.increment("fromDate");
                        queries.add(MatchQuery.of(m -> m.field("date").query(fromDate))._toQuery());
                    }
                    if (StringUtils.isNotBlank((CharSequence)toDate)) {
                        this.myCounter.increment("toDate");
                        queries.add(MatchQuery.of(m -> m.field("date").query(toDate))._toQuery());
                    }
                    if (queries.isEmpty()) {
                        throw new ScholixException("No valid query parameters provided");
                    }
                    Query finalQuery = this.createFinalQuery(queries);
                    SearchResponse scholixRes = client.search(s -> s.index(this.elasticSearchProperties.getIndexName(), new String[0]).query(finalQuery).from(Integer.valueOf((int)(page * (long)pageSize.intValue()))).size(pageSize), ScholixFlat.class);
                    ct = client.count(s -> s.index(this.elasticSearchProperties.getIndexName(), new String[0]).query(finalQuery));
                    if (ct.count() <= 0L) break block31;
                    Map idMap = this.retrieveResources(client, this.extractIdentifiersFromScholix(scholixRes.hits().hits()));
                    immutablePair2 = new ImmutablePair((Object)ct.count(), scholixRes.hits().hits().stream().map(Hit::source).map(s -> {
                        try {
                            return this.generateScholix(s, (ScholixResource)idMap.get(s.getSourceId()), (ScholixResource)idMap.get(s.getTargetId()));
                        }
                        catch (ScholixException e) {
                            throw new RuntimeException(e);
                        }
                    }).toList());
                    if (client == null) break block32;
                    try {
                        this.connectionPool.returnResource((Object)client);
                    }
                    catch (ScholixException e) {
                        throw new ScholixException("Error returning resource to pool", (Throwable)e);
                    }
                }
                return immutablePair2;
            }
            immutablePair = new ImmutablePair((Object)ct.count(), new ArrayList());
            if (client == null) break block33;
            try {
                this.connectionPool.returnResource((Object)client);
            }
            catch (ScholixException e) {
                throw new ScholixException("Error returning resource to pool", (Throwable)e);
            }
        }
        return immutablePair;
        catch (Throwable e) {
            try {
                throw new ScholixException(e);
            }
            catch (Throwable throwable) {
                if (client != null) {
                    try {
                        this.connectionPool.returnResource(client);
                    }
                    catch (ScholixException e2) {
                        throw new ScholixException("Error returning resource to pool", (Throwable)e2);
                    }
                }
                throw throwable;
            }
        }
    }
}

