/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholexplorer.api.controller;

import eu.dnetlib.dhp.schema.sx.api.model.v1.LinkPublisher;
import eu.dnetlib.scholexplorer.api.ScholixException;
import eu.dnetlib.scholexplorer.api.index.ScholixIndexManager;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
@Tag(name="Datasources")
public class DatasourceV1 {
    @Autowired
    private ScholixIndexManager manager;

    @Timed(value="scholix_index_request_links", description="Time taken to return all datasources on Version 1.0 of Scholix")
    @Operation(summary="Get all Datasources", description="returns a list of all datasources")
    @GetMapping(value={"/listDatasources"})
    public List<LinkPublisher> getDatasources() throws ScholixException {
        ArrayList<LinkPublisher> result = new ArrayList<LinkPublisher>();
        this.manager.getLinkProviders().forEach((k, v) -> result.add(new LinkPublisher().name(k).totalRelationships(Integer.valueOf(v.intValue()))));
        return result;
    }
}

