/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholix.api.index;

import eu.dnetlib.dhp.schema.sx.scholix.Scholix;
import eu.dnetlib.scholix.api.ScholixException;
import eu.dnetlib.scholix.api.TaggedCounter;
import eu.dnetlib.scholix.api.index.ElasticSearchPool;
import eu.dnetlib.scholix.api.index.ElasticSearchProperties;
import eu.dnetlib.scholix.api.index.ScholixIndexManager;
import io.micrometer.core.annotation.Timed;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class ScholixIndexManager {
    @Autowired
    ElasticSearchProperties elasticSearchProperties;
    @Autowired
    ElasticSearchPool connectionPool;
    @Autowired
    TaggedCounter myCounter;

    private QueryBuilder createObjectTypeQuery(RelationPrefix prefix, String objectType) throws ScholixException {
        if (prefix == null) {
            throw new ScholixException("prefix cannot be null");
        }
        return new NestedQueryBuilder(String.format("%s", prefix), (QueryBuilder)new TermQueryBuilder(String.format("%s.objectType", prefix), objectType), ScoreMode.None);
    }

    private QueryBuilder createPidTypeQuery(RelationPrefix prefix, String pidTypeValue) throws ScholixException {
        if (prefix == null) {
            throw new ScholixException("prefix cannot be null");
        }
        return new NestedQueryBuilder(String.format("%s.identifier", prefix), (QueryBuilder)new TermQueryBuilder(String.format("%s.identifier.schema", prefix), pidTypeValue), ScoreMode.None);
    }

    private QueryBuilder createLinkProviderQuery(String providerName) throws ScholixException {
        if (providerName == null) {
            throw new ScholixException("prefix cannot be null");
        }
        return new NestedQueryBuilder("linkprovider", (QueryBuilder)new TermQueryBuilder("linkprovider.name", providerName), ScoreMode.None);
    }

    private QueryBuilder createLinkPublisherQuery(RelationPrefix prefix, String publisher) throws ScholixException {
        if (prefix == null) {
            throw new ScholixException("prefix cannot be null");
        }
        return new NestedQueryBuilder(String.format("%s.publisher", prefix), (QueryBuilder)new TermQueryBuilder(String.format("%s.publisher.name", prefix), publisher), ScoreMode.None);
    }

    private QueryBuilder createPidValueQuery(RelationPrefix prefix, String pidValue) throws ScholixException {
        if (prefix == null) {
            throw new ScholixException("prefix cannot be null");
        }
        return new NestedQueryBuilder(String.format("%s.identifier", prefix), (QueryBuilder)new TermQueryBuilder(String.format("%s.identifier.identifier", prefix), pidValue), ScoreMode.None);
    }

    private QueryBuilder createFinalQuery(List<QueryBuilder> queries) throws ScholixException {
        if (queries == null || queries.isEmpty()) {
            throw new ScholixException("the list of queries must be not empty");
        }
        if (queries.size() == 1) {
            return queries.get(0);
        }
        BoolQueryBuilder b = new BoolQueryBuilder();
        b.must().addAll(queries);
        return b;
    }

    private void incrementPidCounter(RelationPrefix prefix, String value) {
        switch (value.toLowerCase()) {
            case "doi": {
                this.myCounter.increment(String.format("%s_doi", prefix));
                break;
            }
            case "pmc": {
                this.myCounter.increment(String.format("%s_pmc", prefix));
                break;
            }
            default: {
                this.myCounter.increment(String.format("%s_other", prefix));
            }
        }
    }

    public List<Pair<String, Long>> totalLinksByProvider(String filterName) throws ScholixException {
        MatchAllQueryBuilder query = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filterName}) ? this.createLinkProviderQuery(filterName) : QueryBuilders.matchAllQuery();
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)query).withSearchType(SearchType.DEFAULT).withPageable((Pageable)PageRequest.of((int)0, (int)10)).addAggregation(AggregationBuilders.nested((String)"nested", (String)"linkprovider").subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"by_map").field("linkprovider.name")).size(100).minDocCount(1L))).build();
        Pair resource = (Pair)this.connectionPool.getResource();
        ElasticsearchRestTemplate client = (ElasticsearchRestTemplate)resource.getValue();
        SearchHits hits = client.search((Query)searchQuery, Scholix.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
        Aggregations aggregations = hits.getAggregations();
        this.connectionPool.returnResource((Object)resource);
        if (aggregations == null) {
            return null;
        }
        Aggregation aggByMap = (Aggregation)((ParsedNested)aggregations.asMap().get("nested")).getAggregations().asMap().get("by_map");
        return ((ParsedStringTerms)aggByMap).getBuckets().stream().map(b -> new ImmutablePair((Object)b.getKeyAsString(), (Object)b.getDocCount())).collect(Collectors.toList());
    }

    public List<Pair<String, Long>> totalLinksPublisher(RelationPrefix prefix, String filterName) throws ScholixException {
        MatchAllQueryBuilder query = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filterName}) ? this.createLinkPublisherQuery(prefix, filterName) : QueryBuilders.matchAllQuery();
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)query).withSearchType(SearchType.DEFAULT).withPageable((Pageable)PageRequest.of((int)0, (int)10)).addAggregation(AggregationBuilders.nested((String)"nested", (String)String.format("%s.publisher", prefix)).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"by_map").field(String.format("%s.publisher.name", prefix))).size(100).minDocCount(1L))).build();
        Pair resource = (Pair)this.connectionPool.getResource();
        ElasticsearchRestTemplate client = (ElasticsearchRestTemplate)resource.getValue();
        SearchHits hits = client.search((Query)searchQuery, Scholix.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
        Aggregations aggregations = hits.getAggregations();
        this.connectionPool.returnResource((Object)resource);
        if (aggregations == null) {
            return null;
        }
        Aggregation aggByMap = (Aggregation)((ParsedNested)aggregations.asMap().get("nested")).getAggregations().asMap().get("by_map");
        return ((ParsedStringTerms)aggByMap).getBuckets().stream().map(b -> new ImmutablePair((Object)b.getKeyAsString(), (Object)b.getDocCount())).collect(Collectors.toList());
    }

    @Timed(value="scholix.index.request.links", description="Time taken to request index")
    public Pair<Long, List<Scholix>> linksFromPid(String linkProvider, String targetPid, String targetPidType, String targetPublisher, String targetType, String sourcePid, String sourcePidType, String sourcePublisher, String sourceType, Integer page) throws ScholixException {
        if (sourcePid == null && sourcePidType == null && targetPid == null && targetPidType == null && sourcePublisher == null && targetPublisher == null && linkProvider == null) {
            throw new ScholixException("One of sourcePid, targetPid, sourcePublisher, targetPublisher, linkProvider should be not null");
        }
        ArrayList<QueryBuilder> queries = new ArrayList<QueryBuilder>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{linkProvider})) {
            this.myCounter.increment("linkProvider");
            queries.add(this.createLinkProviderQuery(linkProvider));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{targetPid})) {
            this.myCounter.increment("targetPid");
            queries.add(this.createPidValueQuery(RelationPrefix.target, targetPid));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sourcePid})) {
            this.myCounter.increment("sourcePid");
            queries.add(this.createPidValueQuery(RelationPrefix.source, sourcePid));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{targetPidType})) {
            assert (targetPidType != null);
            this.incrementPidCounter(RelationPrefix.target, targetPidType);
            queries.add(this.createPidTypeQuery(RelationPrefix.target, targetPidType));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sourcePidType})) {
            assert (sourcePidType != null);
            this.incrementPidCounter(RelationPrefix.source, sourcePidType);
            queries.add(this.createPidTypeQuery(RelationPrefix.source, sourcePidType));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{targetType})) {
            if ("dataset".equalsIgnoreCase(targetType) || "publication".equalsIgnoreCase(targetType)) {
                this.myCounter.increment(String.format("targetType_%s", targetType));
            }
            queries.add(this.createObjectTypeQuery(RelationPrefix.target, targetType));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sourceType})) {
            if ("dataset".equalsIgnoreCase(sourceType) || "publication".equalsIgnoreCase(sourceType)) {
                this.myCounter.increment(String.format("sourceType_%s", sourceType));
            }
            queries.add(this.createObjectTypeQuery(RelationPrefix.source, sourceType));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{targetPublisher})) {
            this.myCounter.increment("targetPublisher");
            queries.add(this.createLinkPublisherQuery(RelationPrefix.target, targetPublisher));
        }
        QueryBuilder result = this.createFinalQuery(queries);
        NativeSearchQuery finalQuery = new NativeSearchQueryBuilder().withQuery(result).withPageable((Pageable)PageRequest.of((int)page, (int)10)).build();
        Pair resource = (Pair)this.connectionPool.getResource();
        ElasticsearchRestTemplate client = (ElasticsearchRestTemplate)resource.getValue();
        long tt = client.count((Query)finalQuery, Scholix.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
        SearchHits scholixRes = client.search((Query)finalQuery, Scholix.class, IndexCoordinates.of((String[])new String[]{this.elasticSearchProperties.getIndexName()}));
        this.connectionPool.returnResource((Object)resource);
        return new ImmutablePair((Object)tt, scholixRes.stream().map(SearchHit::getContent).collect(Collectors.toList()));
    }
}

