/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.solr;

import java.io.Serializable;
import java.util.Objects;

public class CloudClientParams
implements Serializable {
    public static final int DEFAULT_ZKCLIENTTIMEOUT = 30000;
    public static final int DEFAULT_ZKCONNECTTIMEOUT = 60000;
    public static final int DEFAULT_HTTPCONNECTIMEOUT_MS = 30000;
    public static final int DEFAULT_HTTPSOCKETTIMEOUT_MS = 60000;
    public static final int DEFAULT_HTTP_MAX_CONNECTIONS_TOTAL = 12;
    public static final int DEFAULT_HTTP_MAX_CONNECTIONS_PER_ROUTE = 3;
    private final String zkHost;
    private final String collection;
    private final int zkClientTimeout;
    private final int zkConnectTimeout;
    private final int httpConnectTimeoutMillis;
    private final int httpSocketTimeoutMillis;
    private final int maxConnTotal;
    private final int maxConnPerRoute;

    public CloudClientParams(String zkHost, String collection, int zkClientTimeout, int zkConnectTimeout, int httpConnectTimeoutMillis, int httpSocketTimeoutMillis, int maxConnTotal, int maxConnPerRoute) {
        this.zkHost = zkHost;
        this.collection = collection;
        this.zkClientTimeout = zkClientTimeout;
        this.zkConnectTimeout = zkConnectTimeout;
        this.httpConnectTimeoutMillis = httpConnectTimeoutMillis;
        this.httpSocketTimeoutMillis = httpSocketTimeoutMillis;
        this.maxConnTotal = maxConnTotal;
        this.maxConnPerRoute = maxConnPerRoute;
    }

    public CloudClientParams(String zkHost, String collection, int zkClientTimeout, int zkConnectTimeout) {
        this(zkHost, collection, zkClientTimeout, zkConnectTimeout, 30000, 60000, 12, 3);
    }

    public CloudClientParams(String zkHost, String collection, int httpConnectTimeoutMillis, int httpSocketTimeoutMillis, int maxConnTotal, int maxConnPerRoute) {
        this(zkHost, collection, 30000, 60000, httpConnectTimeoutMillis, httpSocketTimeoutMillis, maxConnTotal, maxConnPerRoute);
    }

    public CloudClientParams(String zkHost, String collection) {
        this(zkHost, collection, 30000, 60000);
    }

    public String getZkHost() {
        return this.zkHost;
    }

    public String getCollection() {
        return this.collection;
    }

    public int getZkClientTimeout() {
        return this.zkClientTimeout;
    }

    public int getZkConnectTimeout() {
        return this.zkConnectTimeout;
    }

    public int getHttpConnectTimeoutMillis() {
        return this.httpConnectTimeoutMillis;
    }

    public int getHttpSocketTimeoutMillis() {
        return this.httpSocketTimeoutMillis;
    }

    public int getMaxConnTotal() {
        return this.maxConnTotal;
    }

    public int getMaxConnPerRoute() {
        return this.maxConnPerRoute;
    }

    public int hashCode() {
        return Objects.hash(this.getZkHost(), this.getCollection(), this.getZkClientTimeout(), this.getZkConnectTimeout());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CloudClientParams other = (CloudClientParams)obj;
        return Objects.equals(this.zkHost, other.zkHost) && Objects.equals(this.collection, other.collection) && Objects.equals(this.zkClientTimeout, other.zkClientTimeout) && Objects.equals(this.zkConnectTimeout, other.zkConnectTimeout);
    }
}

